<?php
/**
 * Telegram Webhook - DNet VPN Bot (PHP + MySQL)
 * نسخه V2 (مطابق نیازمندی‌های جدید)
 *
 * نکته: این فایل نقطه ورود وبهوک است و باید سریع پاسخ دهد.
 */

require __DIR__ . '/functions.php';

$update = json_decode(file_get_contents('php://input'), true);
if (!$update) { http_response_code(200); exit('OK'); }

// ✅ جلوگیری از فشار همزمان روی دیتابیس (رفع خطای Too many connections)
// در هاست‌های اشتراکی، وبهوک ممکن است همزمان چند پردازش باز کند و به سقف کانکشن MySQL بخورد.
// با یک فایل‌لاک کوتاه، پردازش‌ها پشت‌سرهم انجام می‌شوند.
$__lockFp = @fopen(sys_get_temp_dir() . '/dnet_vpn_bot.lock', 'c');
if ($__lockFp) {
    $start = microtime(true);
    $locked = false;
    while ((microtime(true) - $start) < 2.0) { // حداکثر 2 ثانیه صبر
        if (@flock($__lockFp, LOCK_EX | LOCK_NB)) { $locked = true; break; }
        usleep(100000); // 100ms
    }
    if (!$locked) {
        // اگر نتوانستیم لاک بگیریم، سریع OK برگردانیم تا تلگرام ریترای نکند.
        http_response_code(200);
        exit('OK');
    }
}

try {
    if (isset($update['callback_query'])) {
        handleCallback($update['callback_query']);
    } elseif (isset($update['message'])) {
        handleMessage($update['message']);
    }
} catch (Throwable $e) {
    log_error('UNCAUGHT EXCEPTION', ['msg' => $e->getMessage(), 'file' => $e->getFile(), 'line' => $e->getLine()]);
}

http_response_code(200);
exit('OK');

function handleMessage(array $m) {
    $chat_id = (int)($m['chat']['id'] ?? 0);
    $type = $m['chat']['type'] ?? 'private';
    if ($type !== 'private' || $chat_id === 0) return;

    // ✅ اجبار عضویت (قبل از هر پردازش پیام/دستور)
    // توجه: در چت خصوصی، chat_id همان user_id است.
    if (!forceJoinCheck($chat_id, ['user_id' => (int)($m['from']['id'] ?? $chat_id)])) {
        return;
    }

    $text = $m['text'] ?? '';

    // ثبت/آپدیت کاربر
    $uinfo = ensureUser($m);
    $user_id = (int)($uinfo['id'] ?? 0);
    $is_new_user = !empty($uinfo['is_new']);

    // ⛔️ حذف کامل دکمه «پنل ادمین» از نوار پیام (در صورت تنظیم قبلی)
    if (isAdmin($chat_id)) {
        removeCustomChatMenuButtonForChat($chat_id);
    }

    // بلاک بودن کاربر
    $u = getUserByChatId($chat_id);
    if ($u && (int)$u['is_blocked'] === 1) {
        sendMessage($chat_id, "⛔️ دسترسی شما مسدود شده است.", null);
        return;
    }

    // (اجباری) چک عضویت قبلاً انجام شده است.

    // وضعیت جاری
    $st = getState($chat_id);
    if ($st && !empty($st['expired'])) {
        $s = (string)($st['state'] ?? '');

        if ($s === 'buy_wait_receipt') {
            clearState($chat_id);
            sendMessage($chat_id, "⏱ مهلت پرداخت شما به پایان رسید و خرید به صورت خودکار لغو شد.", startKeyboardFor($chat_id));
            return;
        }

        if ($s === 'wallet_topup_wait_receipt') {
            clearState($chat_id);
            sendMessage($chat_id, "⏱ مهلت شارژ کیف پول شما به پایان رسید و درخواست به صورت خودکار لغو شد.", startKeyboardFor($chat_id));
            return;
        }
    }

    // /start با پارامتر (لینک زیرمجموعه‌گیری / کانفیگ رایگان)
    if (strpos($text, '/start ') === 0) {
        ensureBotMenuButton();
        clearState($chat_id);

        $payload = trim(substr($text, strlen('/start ')));
        $didAction = false;

        // مثال: ref_123
        if ($is_new_user && strpos($payload, 'ref_') === 0) {
            $refId = (int)substr($payload, strlen('ref_'));
            if ($refId > 0 && $refId !== $user_id) {
                // فقط اگر referrer وجود داشته باشد
                $pdo = db();
                $chk = $pdo->prepare("SELECT id FROM users WHERE id=? LIMIT 1");
                $chk->execute([$refId]);
                if ($chk->fetchColumn()) {
                    recordReferral($refId, $user_id);
                }
            }
        }

        // لینک مستقیم کانفیگ رایگان: /start freecfg یا /start freecfg_xxx
        if (!isAdmin($chat_id) && ($payload === 'freecfg' || strpos($payload, 'freecfg_') === 0)) {
            if (!freeConfigIsEnabled()) {
                sendMessage($chat_id, "❌ کانفیگ رایگان فعلاً غیرفعال است.", userMenuKeyboard());
                $didAction = true;
            } else {
                $link = getFreeSubLink();
                if ($link === '') {
                    sendMessage($chat_id, "⚠️ لینک کانفیگ رایگان هنوز توسط ادمین تنظیم نشده است.", userMenuKeyboard());
                    $didAction = true;
                } else {
                    $msg = "🎁 <b>کانفیگ رایگان</b>\n\n";
                    $msg .= "لینک ساب:\n<code>" . htmlspecialchars($link) . "</code>";
                    sendMessage($chat_id, $msg, userMenuKeyboard());
                    recordFreeConfigUsageForChatId($chat_id);
                    $didAction = true;
                }
            }
        }

        // اگر یک اکشن دیپ‌لینک انجام شد (مثل کانفیگ رایگان)، پیام خوش‌آمد/منو دوباره ارسال نشود.
        if ($didAction) {
            return;
        }

        if (isAdmin($chat_id)) {
            sendMessage($chat_id, "👑 پنل ادمین\n\nیکی از گزینه‌های زیر را انتخاب کنید:", adminMenuKeyboard());
        } else {
            sendMessage($chat_id, "سلام! خوش آمدید 🌟\n\nیکی از گزینه‌های زیر را انتخاب کنید:", userMenuKeyboard());
        }
        return;
    }

    // بازگشت سریع
    if ($text === '/start') {
        ensureBotMenuButton();
        clearState($chat_id);

        if (isAdmin($chat_id)) {
            sendMessage($chat_id, "👑 پنل ادمین\n\nیکی از گزینه‌های زیر را انتخاب کنید:", adminMenuKeyboard());
        } else {
            sendMessage($chat_id, "سلام! خوش آمدید 🌟\n\nیکی از گزینه‌های زیر را انتخاب کنید:", userMenuKeyboard());
        }
        return;
    }

    // اگر ادمین /start نگفته ولی در حال state است، اجازه خروج با «بازگشت»
    if ($text === 'بازگشت' || $text === '🔙 بازگشت' || $text === 'منو' || $text === '🏠 منو') {
        clearState($chat_id);
        sendMessage($chat_id, "✅ بازگشت به منو.", startKeyboardFor($chat_id));
        return;
    }


    // ---- فالبک: اگر کیبورد بخش تخفیف باز مانده ولی state پاک شده باشد ----
    if (isAdmin($chat_id) && ($text === '🗑 حذف کد تخفیف' || $text === 'حذف کد تخفیف')) {
        if (!discountTablesExist() || !discountAdminColumnsReady()) {
            sendMessage($chat_id, "⚠️ بخش کد تخفیف نیاز به اجرای SQL دیتابیس دارد.

ابتدا جدول‌ها/ستون‌ها را بسازید سپس دوباره تلاش کنید.", adminMenuKeyboard());
            return;
        }
        $codes = listDiscountCodesAll();
        if (!$codes) {
            // برگرد به منوی تخفیف
            clearState($chat_id);
            setState($chat_id, 'admin_discount_menu');
            sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
            return;
        }
        clearState($chat_id);
        setState($chat_id, 'admin_disc_delete_select_code');
        sendMessage($chat_id, "🗑 حذف کد تخفیف

یک کد را از لیست انتخاب کنید یا «🗑 حذف همه» را بزنید:", adminDiscountCodesKeyboardWithDeleteAll($codes));
        return;
    }

    // --- State Machine ---
    if ($st && empty($st['expired'])) {
        $state = $st['state'] ?? '';
        $data = $st['data'] ?? [];

        // ---------------- USER STATES ----------------
        if (!isAdmin($chat_id)) {

            // ===== کیف پول: شارژ توسط کاربر با ارسال فیش و تایید ادمین =====
            if ($state === 'wallet_topup_wait_amount') {
                $raw = (string)$text;
                $num = preg_replace('/[^0-9]/', '', $raw);
                $amount = (int)$num;

                if ($amount < 1000) {
                    sendMessage($chat_id, "❌ مبلغ نامعتبر است. لطفاً مبلغ را به تومان و فقط عددی ارسال کنید (حداقل 1000).\n\nبرای لغو: 🔙 بازگشت");
                    return;
                }

                $data['amount_toman'] = $amount;

                $conf = require __DIR__ . '/config.php';
                $timeoutMin = (int)($conf['WALLET_TOPUP_TIMEOUT_MINUTES'] ?? 30);
                if ($timeoutMin < 5) $timeoutMin = 30;
                $expires = time() + $timeoutMin * 60;

                setState($chat_id, 'wallet_topup_wait_receipt', $data, $expires);

                $card = getCardNumberValue();
                $holder = getCardHolderValue();

                $msg = "➕ شارژ کیف پول\n\n";
                $msg .= "مبلغ قابل پرداخت: <b>" . formatToman($amount) . " تومان</b>\n";
                if ($card !== '') $msg .= "شماره کارت: <code>{$card}</code>\n";
                if ($holder !== '') $msg .= "به نام: <b>" . htmlspecialchars($holder) . "</b>\n";
                $msg .= "\n⏳ مهلت ارسال فیش: <b>{$timeoutMin} دقیقه</b>\n";
                $msg .= "بعد از واریز، <b>فیش پرداخت</b> را به صورت عکس یا فایل همینجا ارسال کنید.";

                sendMessage($chat_id, $msg, userMenuKeyboard());
                return;
            }

            if ($state === 'wallet_topup_wait_receipt') {
                $hasReceipt = isset($m['photo']) || isset($m['document']);
                if (!$hasReceipt) {
                    sendMessage($chat_id, "لطفاً فیش پرداخت را به صورت <b>عکس</b> یا <b>فایل</b> ارسال کنید.\n\nبرای لغو: 🔙 بازگشت");
                    return;
                }

                $user = getUserByChatId($chat_id);
                if (!$user) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                    return;
                }

                $amount = (int)($data['amount_toman'] ?? 0);
                if ($amount < 1000) $amount = 0;

                $pdo = db();
                $now = time();

                if (!walletTopupsTableExists()) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ قابلیت شارژ کیف پول هنوز روی دیتابیس نصب نشده است.\nلطفاً اسکریپت آپدیت دیتابیس را اجرا کنید.", userMenuKeyboard());
                    return;
                }

                // ثبت درخواست شارژ
                $stmt = $pdo->prepare("INSERT INTO wallet_topups (user_id, amount_toman, status, receipt_message_id, created_at) VALUES (?,?, 'pending', NULL, ?)");
                $stmt->execute([(int)$user['id'], $amount, $now]);
                $topup_id = (int)$pdo->lastInsertId();

                // کپی فیش برای ادمین
                $copy = copyMessage(ADMIN_ID, $chat_id, $m['message_id']);
                $receipt_mid = ($copy && !empty($copy['ok']) && !empty($copy['result']['message_id'])) ? (int)$copy['result']['message_id'] : null;
                $pdo->prepare("UPDATE wallet_topups SET receipt_message_id=? WHERE id=?")->execute([$receipt_mid, $topup_id]);

                $uname = $user['username'] ? '@' . $user['username'] : '—';
                $details = "💰 درخواست شارژ کیف پول #{$topup_id}\n";
                $details .= formatUserLine($user) . "\n";
                $details .= "یوزرنیم: <b>{$uname}</b>\n\n";
                $details .= "مبلغ: <b>" . formatToman($amount) . " تومان</b>\n";
                $details .= "روش: <b>کارت‌به‌کارت (ارسال فیش)</b>";

                $kb = [
                    'inline_keyboard' => [
                        [
                            ['text' => '✅ تایید شارژ', 'callback_data' => 'admin:wallet:topup:approve:' . $topup_id],
                            ['text' => '⛔️ رد شارژ', 'callback_data' => 'admin:wallet:topup:reject:' . $topup_id],
                        ],
                    ],
                ];

                sendMessage(ADMIN_ID, $details, $kb);

                clearState($chat_id);
                sendMessage($chat_id, "✅ فیش دریافت شد و برای تایید ادمین ارسال شد.\nپس از تایید، موجودی شما افزایش می‌یابد.", userMenuKeyboard());
                return;
            }


            if ($state === 'buy_custom_volume') {
                // قابلیت حجم دلخواه حذف شده؛ جلوگیری از گیر کردن کاربر در استیت‌های قدیمی
                clearState($chat_id);
                sendMessage($chat_id, "❌ قابلیت حجم دلخواه غیرفعال شده است.", userMenuKeyboard());
                return;
            }
            if ($state === 'buy_custom_duration') {
                // قابلیت حجم دلخواه حذف شده؛ جلوگیری از گیر کردن کاربر در استیت‌های قدیمی
                clearState($chat_id);
                sendMessage($chat_id, "❌ قابلیت حجم دلخواه غیرفعال شده است.", userMenuKeyboard());
                return;
            }
            if ($state === 'buy_wait_name') {
                $name = trim($text);
                if (mb_strlen($name) < 2 || mb_strlen($name) > 60) {
                    sendMessage($chat_id, "❌ نام سرویس نامعتبر است. لطفاً بین 2 تا 60 کاراکتر وارد کنید.");
                    return;
                }

                // آماده‌سازی پرداخت (بدون انتظار فیش در این مرحله)
                $data['config_name'] = $name;
                $basePrice = (int)($data['price_toman'] ?? 0);

                $data['base_price_toman'] = $basePrice;
                $data['discount_code_id'] = null;
                $data['discount_code'] = null;
                $data['discount_amount_toman'] = 0;
                $data['final_price_toman'] = $basePrice;

                $msg = buildBuyPaymentMessage($data);

                $kb = [
                    'inline_keyboard' => [
                        [
                            ['text' => '🎟 کد تخفیف', 'callback_data' => 'buy:coupon'],
                            ['text' => '🔄 بروزرسانی', 'callback_data' => 'buy:refresh'],
                        ],
                        [
                            ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'buy:pay:card'],
                            ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'buy:pay:wallet'],
                        ],
                        [
                            ['text' => '❌ لغو', 'callback_data' => 'buy:cancel'],
                        ],
                    ]
                ];

                // ارسال پیام پرداخت و ذخیره message_id برای ویرایش‌های بعدی
                $sent = sendMessage($chat_id, $msg, $kb);
                $payMid = ($sent && !empty($sent['ok']) && !empty($sent['result']['message_id'])) ? (int)$sent['result']['message_id'] : null;
                if ($payMid) $data['pay_msg_id'] = $payMid;

                setState($chat_id, 'buy_payment', $data);

                return;
            }


            if ($state === 'buy_coupon_wait') {
                $code = trim((string)$text);
                $base = (int)($data['base_price_toman'] ?? $data['price_toman'] ?? 0);

                $user = getUserByChatId($chat_id);
                $gk = (string)($data['plan_group_key'] ?? 'bulk');
                $prev = previewDiscountForGroup($code, $base, (int)($user['id'] ?? 0), $gk);
                if (!$prev['ok']) {
                    sendMessage($chat_id, $prev['msg'] . "\n\n🔁 دوباره ارسال کنید یا «بازگشت» را بزنید.");
                    return;
                }

                $data['discount_code_id'] = $prev['code_id'];
                $data['discount_code'] = normalizeDiscountCode($code);
                $data['discount_amount_toman'] = (int)$prev['discount'];
                $data['final_price_toman'] = (int)$prev['final'];

                // برگشت به مرحله پرداخت و بروزرسانی پیام
                setState($chat_id, 'buy_payment', $data);

                $msg = buildBuyPaymentMessage($data);

                $kb = [
                    'inline_keyboard' => [
                        [
                            ['text' => '🎟 کد تخفیف', 'callback_data' => 'buy:coupon'],
                            ['text' => '🔄 بروزرسانی', 'callback_data' => 'buy:refresh'],
                        ],
                        [
                            ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'buy:pay:card'],
                            ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'buy:pay:wallet'],
                        ],
                        [
                            ['text' => '❌ لغو', 'callback_data' => 'buy:cancel'],
                        ],
                    ]
                ];

                $payMid = (int)($data['pay_msg_id'] ?? 0);
                if ($payMid > 0) {
                    editMessageText($chat_id, $payMid, $msg, $kb);
                } else {
                    sendMessage($chat_id, $msg, $kb);
                }

                sendMessage($chat_id, "✅ کد تخفیف اعمال شد و مبلغ بروزرسانی شد.", userMenuKeyboard());
                return;
            }

            if ($state === 'buy_payment') {
                sendMessage($chat_id, "برای ادامه، از دکمه‌های زیر اطلاعات پرداخت استفاده کنید یا «بازگشت» را بزنید.");
                return;
            }

            if ($state === 'buy_wait_receipt') {
                $hasReceipt = isset($m['photo']) || isset($m['document']);
                if (!$hasReceipt) {
                    sendMessage($chat_id, "لطفاً فیش پرداخت را به صورت <b>عکس</b> یا <b>فایل</b> ارسال کنید.");
                    return;
                }

                $user = getUserByChatId($chat_id);
                if (!$user) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                    return;
                }

                $pdo = db();
                $now = time();

                $stmt = $pdo->prepare(
                    "INSERT INTO orders (user_id, config_name, protocol, plan_id, plan_group_key, plan_title, data_gb, duration_days, price_toman, payment_method, discount_code_id, discount_amount_toman, final_price_toman, wallet_tx_id, status, receipt_message_id, created_at, expires_at)\n" .
                    "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NULL,'pending',NULL,?,?)"
                );
                $stmt->execute([
                    (int)$user['id'],
                    (string)($data['config_name'] ?? ''),
                    MAIN_PROTOCOL,
                    isset($data['plan_id']) ? $data['plan_id'] : null,
                    (string)($data['plan_group_key'] ?? 'bulk'),
                    (string)($data['title'] ?? ''),
                    (int)($data['data_gb'] ?? 0),
                    (int)($data['duration_days'] ?? 0),
                    (int)($data['base_price_toman'] ?? $data['price_toman'] ?? 0),
                    'card',
                    !empty($data['discount_code_id']) ? (int)$data['discount_code_id'] : null,
                    (int)($data['discount_amount_toman'] ?? 0),
                    (int)($data['final_price_toman'] ?? $data['price_toman'] ?? 0),
                    $now,
                    (int)($st['expires_at'] ?? null),
                ]);
                $order_id = (int)$pdo->lastInsertId();

                // کپی فیش برای ادمین
                $copy = copyMessage(ADMIN_ID, $chat_id, $m['message_id']);
                $receipt_mid = ($copy && !empty($copy['ok']) && !empty($copy['result']['message_id'])) ? (int)$copy['result']['message_id'] : null;

                $pdo->prepare("UPDATE orders SET receipt_message_id=? WHERE id=?")->execute([$receipt_mid, $order_id]);

                // ارسال جزئیات به ادمین + دکمه ارسال کانفیگ
                $uname = $user['username'] ? '@' . $user['username'] : '—';
                $details = "🧩 سفارش خرید جدید #{$order_id}\n";
                $details .= formatUserLine($user) . "\n";
                $details .= "یوزرنیم: <b>{$uname}</b>\n\n";
                $gk = (string)($data['plan_group_key'] ?? 'bulk');
                $details .= "گروه: <b>" . htmlspecialchars(planGroupTitle($gk)) . "</b>\n";
                $details .= "پلن: <b>" . htmlspecialchars($data['title'] ?? '—') . "</b>\n";
                $details .= "نام سرویس: <b>" . htmlspecialchars($data['config_name'] ?? '') . "</b>\n";
                $details .= "پروتکل: <b>" . MAIN_PROTOCOL . "</b>\n";
                $details .= "حجم: <b>" . htmlspecialchars(formatPlanDataLabel((int)($data['data_gb'] ?? 0))) . "</b>\n";
                $details .= "مدت: <b>" . (int)$data['duration_days'] . " روز</b>\n";
                $baseP = (int)($data['base_price_toman'] ?? $data['price_toman'] ?? 0);
                $discP = (int)($data['discount_amount_toman'] ?? 0);
                $finalP = (int)($data['final_price_toman'] ?? $baseP);
                $details .= "روش پرداخت: <b>کارت‌به‌کارت</b>\n";
                if ($discP > 0) {
                    $details .= "قیمت پایه: <b>" . formatToman($baseP) . " تومان</b>\n";
                    $details .= "تخفیف: <b>" . formatToman($discP) . " تومان</b>\n";
                    $details .= "مبلغ نهایی: <b>" . formatToman($finalP) . " تومان</b>\n";
                } else {
                    $details .= "قیمت: <b>" . formatToman($finalP) . " تومان</b>\n";
                }

                $kb = [
                    'inline_keyboard' => [
                        [
							['text' => '📤 ارسال کانفیگ', 'callback_data' => 'admin:order:sendcfg:' . $order_id],
							['text' => '⛔️ رد فیش (فیک)', 'callback_data' => 'admin:order:reject:' . $order_id],
                        ]
                    ]
                ];

                sendMessage(ADMIN_ID, $details, $kb, 'HTML', $receipt_mid);

                clearState($chat_id);
                sendMessage($chat_id, "✅ فیش پرداخت دریافت شد. پس از بررسی، سرویس برای شما ارسال می‌شود.", userMenuKeyboard());
                return;
            }


            if ($state === 'renew_coupon_wait') {
                $code = trim((string)$text);
                $base = (int)($data['base_price_toman'] ?? 0);

                $user = getUserByChatId($chat_id);
                $gk = (string)($data['plan_group_key'] ?? 'bulk');
                $prev = previewDiscountForGroup($code, $base, (int)($user['id'] ?? 0), $gk);
                if (!$prev['ok']) {
                    sendMessage($chat_id, $prev['msg'] . "\n\n🔁 دوباره ارسال کنید یا «بازگشت» را بزنید.");
                    return;
                }

                $data['discount_code_id'] = $prev['code_id'];
                $data['discount_code'] = normalizeDiscountCode($code);
                $data['discount_amount_toman'] = (int)$prev['discount'];
                $data['final_price_toman'] = (int)$prev['final'];

                setState($chat_id, 'renew_payment', $data);

                $user = getUserByChatId($chat_id);
                if (!$user) return;
                $pdo = db();
                $stmt = $pdo->prepare("SELECT * FROM configs WHERE id=? AND user_id=? LIMIT 1");
                $stmt->execute([(int)($data['config_id'] ?? 0), (int)$user['id']]);
                $cfg = $stmt->fetch();
                if (!$cfg) return;

                $msg = buildRenewPaymentMessage($cfg, $data);

                $kb = [
                    'inline_keyboard' => [
                        [
                            ['text' => '🎟 کد تخفیف', 'callback_data' => 'renew:coupon'],
                            ['text' => '🔄 بروزرسانی', 'callback_data' => 'renew:refresh'],
                        ],
                        [
                            ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'renew:pay:card'],
                            ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'renew:pay:wallet'],
                        ],
                        [
                            ['text' => '❌ لغو', 'callback_data' => 'renew:cancel'],
                        ],
                    ]
                ];

                $payMid = (int)($data['pay_msg_id'] ?? 0);
                if ($payMid > 0) {
                    editMessageText($chat_id, $payMid, $msg, $kb);
                } else {
                    sendMessage($chat_id, $msg, $kb);
                }

                sendMessage($chat_id, "✅ کد تخفیف اعمال شد و مبلغ بروزرسانی شد.", userMenuKeyboard());
                return;
            }

            if ($state === 'renew_payment') {
                sendMessage($chat_id, "برای ادامه، از دکمه‌های زیر اطلاعات پرداخت استفاده کنید یا «بازگشت» را بزنید.");
                return;
            }

            if ($state === 'renew_wait_receipt') {
                $hasReceipt = isset($m['photo']) || isset($m['document']);
                if (!$hasReceipt) {
                    sendMessage($chat_id, "لطفاً فیش تمدید را به صورت <b>عکس</b> یا <b>فایل</b> ارسال کنید.");
                    return;
                }

                $user = getUserByChatId($chat_id);
                if (!$user) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                    return;
                }

                $config_id = (int)($data['config_id'] ?? 0);
                $pdo = db();
                $cfg = $pdo->prepare("SELECT * FROM configs WHERE id=? AND user_id=? LIMIT 1");
                $cfg->execute([$config_id, (int)$user['id']]);
                $cfgRow = $cfg->fetch();
                if (!$cfgRow) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ کانفیگ انتخاب‌شده یافت نشد.", userMenuKeyboard());
                    return;
                }

                $now = time();
                $stmt = $pdo->prepare("INSERT INTO renewals (user_id, config_id, status, receipt_message_id, created_at, price_toman, payment_method, discount_code_id, discount_amount_toman, final_price_toman, wallet_tx_id) VALUES (?,?, 'pending', NULL, ?, ?, 'card', ?, ?, ?, NULL)");
                $stmt->execute([(int)$user['id'], $config_id, $now, (int)($data['base_price_toman'] ?? 0), !empty($data['discount_code_id']) ? (int)$data['discount_code_id'] : null, (int)($data['discount_amount_toman'] ?? 0), (int)($data['final_price_toman'] ?? $data['base_price_toman'] ?? 0)]);
                $renewal_id = (int)$pdo->lastInsertId();

                $copy = copyMessage(ADMIN_ID, $chat_id, $m['message_id']);
                $receipt_mid = ($copy && !empty($copy['ok']) && !empty($copy['result']['message_id'])) ? (int)$copy['result']['message_id'] : null;
                $pdo->prepare("UPDATE renewals SET receipt_message_id=? WHERE id=?")->execute([$receipt_mid, $renewal_id]);

                $details = "🔁 درخواست تمدید #{$renewal_id}\n";
                $details .= formatUserLine($user) . "\n\n";
                $baseP = (int)($data['base_price_toman'] ?? 0);
                $discP = (int)($data['discount_amount_toman'] ?? 0);
                $finalP = (int)($data['final_price_toman'] ?? $baseP);
                $details .= "روش پرداخت: <b>کارت‌به‌کارت</b>\n";
                if ($discP > 0) {
                    $details .= "قیمت پایه: <b>" . formatToman($baseP) . " تومان</b>\n";
                    $details .= "تخفیف: <b>" . formatToman($discP) . " تومان</b>\n";
                    $details .= "مبلغ نهایی: <b>" . formatToman($finalP) . " تومان</b>\n";
                } else {
                    $details .= "قیمت: <b>" . formatToman($finalP) . " تومان</b>\n";
                }

                $details .= "نام کانفیگ: <b>" . htmlspecialchars($cfgRow['name']) . "</b>\n";
                $details .= "لینک کانفیگ:\n<code>" . htmlspecialchars($cfgRow['link']) . "</code>\n";

                $kb = [
                    'inline_keyboard' => [
                        [
							['text' => '✅ تأیید تمدید', 'callback_data' => 'admin:renew:approve:' . $renewal_id],
							['text' => '⛔️ رد فیش (فیک)', 'callback_data' => 'admin:renew:reject:' . $renewal_id],
                        ]
                    ]
                ];

                sendMessage(ADMIN_ID, $details, $kb, 'HTML', $receipt_mid);

                clearState($chat_id);
                sendMessage($chat_id, "✅ فیش تمدید دریافت شد. پس از تأیید ادمین، به شما اطلاع داده می‌شود.", userMenuKeyboard());
                return;
            }

            
if ($state === 'user_cfg_rename') {
    $config_id = (int)($data['config_id'] ?? 0);
    $newName = trim((string)$text);

    if (mb_strlen($newName) < 2 || mb_strlen($newName) > 60) {
        sendMessage($chat_id, "❌ نام نامعتبر است. (2 تا 60 کاراکتر)\n\nبرای لغو: 🔙 بازگشت");
        return;
    }

    if ($config_id < 1 || !renameUserConfig($chat_id, $config_id, $newName)) {
        clearState($chat_id);
        sendMessage($chat_id, "❌ امکان تغییر نام این کانفیگ وجود ندارد.", userMenuKeyboard());
        return;
    }

    clearState($chat_id);
    sendMessage($chat_id, "✅ نام کانفیگ با موفقیت تغییر کرد.", userMenuKeyboard());
    showUserServices($chat_id);
    return;
}

if ($state === 'ticket_wait_message') {
                $user = getUserByChatId($chat_id);
                if (!$user) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                    return;
                }

                $textContent = '';
                if (!empty($m['text'])) {
                    $textContent = $m['text'];
                } elseif (!empty($m['caption'])) {
                    $textContent = $m['caption'];
                } else {
                    $textContent = '(بدون متن)';
                }

                $pdo = db();
                $now = time();
                $stmt = $pdo->prepare("INSERT INTO tickets (user_id, message_text, status, created_at) VALUES (?, ?, 'open', ?)");
                $stmt->execute([(int)$user['id'], $textContent, $now]);
                $ticket_id = (int)$pdo->lastInsertId();

                // اگر پیام مدیا باشد، اول کپی شود تا ادمین آن را ببیند
                $reply_to_mid = null;
                if (isset($m['photo']) || isset($m['document']) || isset($m['video']) || isset($m['voice']) || isset($m['audio']) || isset($m['sticker'])) {
                    $copy = copyMessage(ADMIN_ID, $chat_id, $m['message_id']);
                    if ($copy && !empty($copy['ok']) && !empty($copy['result']['message_id'])) {
                        $reply_to_mid = (int)$copy['result']['message_id'];
                    }
                }

                $info = "🎫 تیکت جدید #{$ticket_id}\n";
                $info .= formatUserLine($user) . "\n\n";
                $info .= "متن پیام:\n" . htmlspecialchars($textContent);

                $kb = [
                    'inline_keyboard' => [
                        [
							['text' => '💬 پاسخ به تیکت', 'callback_data' => 'admin:ticket:reply:' . $ticket_id],
                        ]
                    ]
                ];

                sendMessage(ADMIN_ID, $info, $kb, 'HTML', $reply_to_mid);

                clearState($chat_id);
                sendMessage($chat_id, "✅ پیام شما برای پشتیبانی ارسال شد. به زودی پاسخ داده می‌شود.", userMenuKeyboard());
                return;
            }
        }

        // ---------------- ADMIN STATES ----------------
        if (isAdmin($chat_id)) {

            // =========================
            // 🗂 مدیریت کانفیگ‌ها (گروه‌ها و پلن‌ها)
            // =========================
            if ($state === 'admin_cfg_manage_menu') {

                if (!planGroupsTableExists()) {
                    clearState($chat_id);
                    sendMessage($chat_id, "⚠️ جدول plan_groups در دیتابیس وجود ندارد.\n\n✅ لطفاً SQL آپدیت دیتابیس را اجرا کنید.", adminMenuKeyboard());
                    return;
                }

                if ($text === '➕ اضافه کردن') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_cfg_add_wait_group_key');
                    sendMessage($chat_id, "➕ <b>اضافه کردن</b>\n\n🔑 لطفاً <b>کلید گروه</b> را ارسال کنید (فقط انگلیسی/عدد/_)\nمثال: <code>vip2</code>\n\nبرای لغو: 🔙 بازگشت", adminConfigManageKeyboard());
                    return;
                }

                if ($text === '✏️ ویرایش') {
                    $groups = listPlanGroupsAll();
                    if (!$groups) {
                        sendMessage($chat_id, "ℹ️ گروه فعالی وجود ندارد.", adminConfigManageKeyboard());
                        return;
                    }

                    $ik = [];
                    foreach ($groups as $g) {
                        $key = (string)($g['group_key'] ?? '');
                        $title = (string)($g['title'] ?? $key);
                        if ($key === '') continue;
                        $ik[] = [['text' => "🗂 " . $title, 'callback_data' => 'admin:cfg:edit:select_group:' . $key]];
                    }
                    $ik[] = [['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:edit:back_to_menu']];

                    sendMessage($chat_id, "✏️ <b>ویرایش</b>\n\nیک گروه را انتخاب کنید:", ['inline_keyboard' => $ik]);
                    return;
                }

                

                if ($text === '⛔️ خاموش/روشن گروه') {
                    $groups = listPlanGroupsAll();
                    if (!$groups) {
                        sendMessage($chat_id, "ℹ️ گروهی وجود ندارد.", adminConfigManageKeyboard());
                        return;
                    }

                    $ik = [];
                    foreach ($groups as $g) {
                        $key = (string)($g['group_key'] ?? '');
                        if ($key === '') continue;
                        $title = (string)($g['title'] ?? $key);
                        $active = (int)($g['active'] ?? 1);
                        $tag = $active ? '✅' : '⛔️';
                        $ik[] = [[
                            'text' => $tag . ' ' . $title,
                            'callback_data' => 'admin:cfg:toggle_group:' . $key,
                        ]];
                    }
                    $ik[] = [[
                        'text' => '⬅️ بازگشت',
                        'callback_data' => 'admin:cfg:toggle_group:back',
                    ]];

                    sendMessage($chat_id, "⛔️ <b>خاموش/روشن گروه</b>

روی یک گروه بزنید تا وضعیتش تغییر کند:", ['inline_keyboard' => $ik]);
                    return;
                }
if ($text === '🗑 حذف') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_cfg_delete_menu');
                    sendMessage($chat_id, "🗑 <b>حذف</b>\n\nچه چیزی را می‌خواهید حذف کنید؟", adminConfigDeleteKeyboard());
                    return;
                }

                sendMessage($chat_id, "🗂 مدیریت کانفیگ‌ها\n\nیکی از گزینه‌ها را انتخاب کنید:", adminConfigManageKeyboard());
                return;
            }

            // زیرمنوی حذف
            if ($state === 'admin_cfg_delete_menu') {
                if (!planGroupsTableExists()) {
                    clearState($chat_id);
                    sendMessage($chat_id, "⚠️ جدول plan_groups در دیتابیس وجود ندارد.\n\n✅ لطفاً SQL آپدیت دیتابیس را اجرا کنید.", adminMenuKeyboard());
                    return;
                }

                if ($text === '🗂 گروه‌ها') {
                    $groups = listPlanGroupsAll();
                    if (!$groups) {
                        sendMessage($chat_id, "ℹ️ گروه فعالی وجود ندارد.", adminConfigDeleteKeyboard());
                        return;
                    }

                    $ik = [];
                    foreach ($groups as $g) {
                        $key = (string)($g['group_key'] ?? '');
                        $title = (string)($g['title'] ?? $key);
                        if ($key === '') continue;
                        $ik[] = [['text' => "🗂 حذف گروه: " . $title, 'callback_data' => 'admin:cfg:del:group:' . $key]];
                    }
                    $ik[] = [['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:del:back_to_delete_menu']];

                    sendMessage($chat_id, "🗂 <b>حذف گروه</b>\n\nیک گروه را انتخاب کنید:", ['inline_keyboard' => $ik]);
                    return;
                }

                if ($text === '🧾 پلن‌ها') {
                    $groups = listPlanGroupsAll();
                    if (!$groups) {
                        sendMessage($chat_id, "ℹ️ گروه فعالی وجود ندارد.", adminConfigDeleteKeyboard());
                        return;
                    }

                    $ik = [];
                    foreach ($groups as $g) {
                        $key = (string)($g['group_key'] ?? '');
                        $title = (string)($g['title'] ?? $key);
                        if ($key === '') continue;
                        $ik[] = [['text' => "🧾 پلن‌های گروه: " . $title, 'callback_data' => 'admin:cfg:del:plan_group:' . $key]];
                    }
                    $ik[] = [['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:del:back_to_delete_menu']];

                    sendMessage($chat_id, "🧾 <b>حذف پلن</b>\n\nابتدا گروه را انتخاب کنید:", ['inline_keyboard' => $ik]);
                    return;
                }

                sendMessage($chat_id, "🗑 حذف\n\nیکی از گزینه‌ها را انتخاب کنید:", adminConfigDeleteKeyboard());
                return;
            }

            // =========================
            // ➕ اضافه کردن گروه + پلن
            // =========================
            if ($state === 'admin_cfg_add_wait_group_key') {
                $key = strtolower(trim((string)$text));
                if (!preg_match('/^[a-z0-9_]{3,20}$/i', $key)) {
                    sendMessage($chat_id, "❌ کلید گروه نامعتبر است.\nفقط انگلیسی/عدد/_ و طول ۳ تا ۲۰.\n\nمثال: <code>vip2</code>\n\nبرای لغو: 🔙 بازگشت", adminConfigManageKeyboard());
                    return;
                }

                $exists = getPlanGroupByKey($key);
                if (!empty($exists) && !empty($exists['group_key']) && planGroupsTableExists()) {
                    sendMessage($chat_id, "⚠️ این کلید از قبل وجود دارد. یک کلید دیگر ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminConfigManageKeyboard());
                    return;
                }

                setState($chat_id, 'admin_cfg_add_wait_group_title', ['group_key' => $key]);
                sendMessage($chat_id, "📝 نام/عنوان گروه را ارسال کنید (مثال: VIP 2 | مناسب ترید):", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_group_title') {
                $title = trim((string)$text);
                $groupKey = (string)($data['group_key'] ?? '');

                if ($title === '' || mb_strlen($title, 'UTF-8') < 2 || mb_strlen($title, 'UTF-8') > 80) {
                    sendMessage($chat_id, "❌ عنوان گروه نامعتبر است.\n\nیک عنوان ۲ تا ۸۰ کاراکتری ارسال کنید:", adminConfigManageKeyboard());
                    return;
                }

                $ok = createPlanGroup($groupKey, $title);
                if (!$ok) {
                    sendMessage($chat_id, "❌ ساخت گروه ناموفق بود. (ممکن است کلید تکراری باشد)\n\nبرای لغو: 🔙 بازگشت", adminConfigManageKeyboard());
                    clearState($chat_id);
                    setState($chat_id, 'admin_cfg_manage_menu');
                    return;
                }

                setState($chat_id, 'admin_cfg_add_wait_plan_title', ['group_key' => $groupKey, 'group_title' => $title]);
                sendMessage($chat_id, "🧾 عنوان پلن را ارسال کنید (مثال: 10 گیگ | 30 روزه):", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_plan_title') {
                $ptitle = trim((string)$text);
                $groupKey = (string)($data['group_key'] ?? '');

                if ($ptitle === '' || mb_strlen($ptitle, 'UTF-8') < 2 || mb_strlen($ptitle, 'UTF-8') > 80) {
                    sendMessage($chat_id, "❌ عنوان پلن نامعتبر است.\n\nیک عنوان ۲ تا ۸۰ کاراکتری ارسال کنید:", adminConfigManageKeyboard());
                    return;
                }

                setState($chat_id, 'admin_cfg_add_wait_data_gb', ['group_key' => $groupKey, 'title' => $ptitle]);
                sendMessage($chat_id, "📦 حجم پلن را به گیگ ارسال کنید (عدد). برای نامحدود: <code>0</code>", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_data_gb') {
                $gb = (int)preg_replace('/[^0-9\-]/', '', (string)$text);
                if ($gb < 0 || $gb > 100000) {
                    sendMessage($chat_id, "❌ حجم نامعتبر است.\nیک عدد بین 0 تا 100000 ارسال کنید.", adminConfigManageKeyboard());
                    return;
                }

                $d = $data;
                $d['data_gb'] = $gb;
                setState($chat_id, 'admin_cfg_add_wait_duration', $d);
                sendMessage($chat_id, "⏳ مدت پلن را به روز ارسال کنید (عدد). مثال: <code>30</code>", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_duration') {
                $days = (int)preg_replace('/[^0-9\-]/', '', (string)$text);
                if ($days < 1 || $days > 36500) {
                    sendMessage($chat_id, "❌ مدت نامعتبر است.\nیک عدد بین 1 تا 36500 ارسال کنید.", adminConfigManageKeyboard());
                    return;
                }

                $d = $data;
                $d['duration_days'] = $days;
                setState($chat_id, 'admin_cfg_add_wait_user_count', $d);
                sendMessage($chat_id, "👥 تعداد کاربر را ارسال کنید (عدد). مثال: <code>2</code>", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_user_count') {
                $uc = (int)preg_replace('/[^0-9\-]/', '', (string)$text);
                if ($uc < 1 || $uc > 50) {
                    sendMessage($chat_id, "❌ تعداد کاربر نامعتبر است.\nیک عدد بین 1 تا 50 ارسال کنید.", adminConfigManageKeyboard());
                    return;
                }

                $d = $data;
                $d['user_count'] = $uc;
                setState($chat_id, 'admin_cfg_add_wait_price', $d);
                sendMessage($chat_id, "💰 قیمت پلن را به تومان ارسال کنید (فقط عدد).", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_add_wait_price') {
                $price = (int)preg_replace('/[^0-9]/', '', (string)$text);
                if ($price < 0) $price = 0;

                $groupKey = (string)($data['group_key'] ?? '');
                $title = (string)($data['title'] ?? '');
                $gb = (int)($data['data_gb'] ?? 0);
                $days = (int)($data['duration_days'] ?? 30);
                $uc = (int)($data['user_count'] ?? 2);

                $pdo = db();
                try {
                    if (plansUserCountColumnExists()) {
                        $st = $pdo->prepare("INSERT INTO plans (group_key, title, protocol, data_gb, duration_days, user_count, price_toman, active) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
                        $st->execute([$groupKey, $title, MAIN_PROTOCOL, $gb, $days, $uc, $price]);
                    } else {
                        // سازگاری با دیتابیس قدیمی (بدون user_count)
                        $st = $pdo->prepare("INSERT INTO plans (group_key, title, protocol, data_gb, duration_days, price_toman, active) VALUES (?, ?, ?, ?, ?, ?, 1)");
                        $st->execute([$groupKey, $title, MAIN_PROTOCOL, $gb, $days, $price]);
                    }
                } catch (Throwable $e) {
                    clearState($chat_id);
                    setState($chat_id, 'admin_cfg_manage_menu');
                    sendMessage($chat_id, "❌ افزودن پلن ناموفق بود.\n\nخطا: <code>" . htmlspecialchars($e->getMessage()) . "</code>", adminConfigManageKeyboard());
                    return;
                }

                clearState($chat_id);
                setState($chat_id, 'admin_cfg_manage_menu');
                sendMessage($chat_id, "✅ گروه و پلن با موفقیت اضافه شد. 🎉", adminConfigManageKeyboard());
                return;
            }

            // =========================
            // ✏️ ویرایش گروه
            // =========================
            if ($state === 'admin_cfg_edit_group_title') {
                $groupKey = (string)($data['group_key'] ?? '');
                $title = trim((string)$text);

                if ($title === '' || mb_strlen($title, 'UTF-8') < 2 || mb_strlen($title, 'UTF-8') > 80) {
                    sendMessage($chat_id, "❌ عنوان نامعتبر است.\nیک عنوان ۲ تا ۸۰ کاراکتری ارسال کنید:", adminConfigManageKeyboard());
                    return;
                }

                $ok = updatePlanGroupTitle($groupKey, $title);
                clearState($chat_id);
                setState($chat_id, 'admin_cfg_manage_menu');

                if ($ok) {
                    sendMessage($chat_id, "✅ نام گروه بروزرسانی شد. ✨", adminConfigManageKeyboard());
                } else {
                    sendMessage($chat_id, "❌ بروزرسانی نام گروه ناموفق بود.", adminConfigManageKeyboard());
                }
                return;
            }

            // =========================
            // ✏️ ویرایش پلن (مرحله‌ای)
            // =========================
            if ($state === 'admin_cfg_edit_plan_wait_title') {
                $planId = (int)($data['plan_id'] ?? 0);
                $newTitle = trim((string)$text);

                if ($newTitle !== '-' && ($newTitle === '' || mb_strlen($newTitle, 'UTF-8') < 2 || mb_strlen($newTitle, 'UTF-8') > 80)) {
                    sendMessage($chat_id, "❌ عنوان نامعتبر است.\nیک عنوان ۲ تا ۸۰ کاراکتری ارسال کنید یا <code>-</code> برای بدون تغییر:", adminConfigManageKeyboard());
                    return;
                }

                $d = $data;
                if ($newTitle !== '-') $d['title'] = $newTitle;

                setState($chat_id, 'admin_cfg_edit_plan_wait_data_gb', $d);
                sendMessage($chat_id, "📦 حجم جدید را ارسال کنید (عدد) یا <code>-</code> برای بدون تغییر.\nبرای نامحدود: <code>0</code>", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_edit_plan_wait_data_gb') {
                $raw = trim((string)$text);
                $d = $data;

                if ($raw !== '-') {
                    $gb = (int)preg_replace('/[^0-9\-]/', '', $raw);
                    if ($gb < 0 || $gb > 100000) {
                        sendMessage($chat_id, "❌ حجم نامعتبر است.\nیک عدد بین 0 تا 100000 یا <code>-</code> ارسال کنید.", adminConfigManageKeyboard());
                        return;
                    }
                    $d['data_gb'] = $gb;
                }

                setState($chat_id, 'admin_cfg_edit_plan_wait_duration', $d);
                sendMessage($chat_id, "⏳ مدت جدید را به روز ارسال کنید یا <code>-</code> برای بدون تغییر.", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_edit_plan_wait_duration') {
                $raw = trim((string)$text);
                $d = $data;

                if ($raw !== '-') {
                    $days = (int)preg_replace('/[^0-9\-]/', '', $raw);
                    if ($days < 1 || $days > 36500) {
                        sendMessage($chat_id, "❌ مدت نامعتبر است.\nیک عدد بین 1 تا 36500 یا <code>-</code> ارسال کنید.", adminConfigManageKeyboard());
                        return;
                    }
                    $d['duration_days'] = $days;
                }

                setState($chat_id, 'admin_cfg_edit_plan_wait_user_count', $d);
                sendMessage($chat_id, "👥 تعداد کاربر جدید را ارسال کنید یا <code>-</code> برای بدون تغییر.", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_edit_plan_wait_user_count') {
                $raw = trim((string)$text);
                $d = $data;

                if ($raw !== '-') {
                    $uc = (int)preg_replace('/[^0-9\-]/', '', $raw);
                    if ($uc < 1 || $uc > 50) {
                        sendMessage($chat_id, "❌ تعداد کاربر نامعتبر است.\nیک عدد بین 1 تا 50 یا <code>-</code> ارسال کنید.", adminConfigManageKeyboard());
                        return;
                    }
                    $d['user_count'] = $uc;
                }

                setState($chat_id, 'admin_cfg_edit_plan_wait_price', $d);
                sendMessage($chat_id, "💰 قیمت جدید را به تومان ارسال کنید یا <code>-</code> برای بدون تغییر.", adminConfigManageKeyboard());
                return;
            }

            if ($state === 'admin_cfg_edit_plan_wait_price') {
                $raw = trim((string)$text);
                $planId = (int)($data['plan_id'] ?? 0);

                $pdo = db();
                try {
                    // مقادیر فعلی
                    $q = $pdo->prepare("SELECT * FROM plans WHERE id=? LIMIT 1");
                    $q->execute([$planId]);
                    $cur = $q->fetch();
                    if (!$cur) {
                        clearState($chat_id);
                        setState($chat_id, 'admin_cfg_manage_menu');
                        sendMessage($chat_id, "❌ پلن یافت نشد.", adminConfigManageKeyboard());
                        return;
                    }

                    $title = (string)($data['title'] ?? $cur['title']);
                    $gb = isset($data['data_gb']) ? (int)$data['data_gb'] : (int)$cur['data_gb'];
                    $days = isset($data['duration_days']) ? (int)$data['duration_days'] : (int)$cur['duration_days'];
                    $uc = isset($data['user_count']) ? (int)$data['user_count'] : (int)($cur['user_count'] ?? 2);
                    $price = ($raw === '-') ? (int)$cur['price_toman'] : (int)preg_replace('/[^0-9]/', '', $raw);

                    if (plansUserCountColumnExists()) {
                        $st = $pdo->prepare("UPDATE plans SET title=?, data_gb=?, duration_days=?, user_count=?, price_toman=? WHERE id=?");
                        $st->execute([$title, $gb, $days, $uc, $price, $planId]);
                    } else {
                        $st = $pdo->prepare("UPDATE plans SET title=?, data_gb=?, duration_days=?, price_toman=? WHERE id=?");
                        $st->execute([$title, $gb, $days, $price, $planId]);
                    }
                } catch (Throwable $e) {
                    clearState($chat_id);
                    setState($chat_id, 'admin_cfg_manage_menu');
                    sendMessage($chat_id, "❌ ویرایش پلن ناموفق بود.\n\nخطا: <code>" . htmlspecialchars($e->getMessage()) . "</code>", adminConfigManageKeyboard());
                    return;
                }

                clearState($chat_id);
                setState($chat_id, 'admin_cfg_manage_menu');
                sendMessage($chat_id, "✅ پلن بروزرسانی شد. ✨", adminConfigManageKeyboard());
                return;
            }


            // =========================
            // ارسال پیام (خصوصی/همگانی)
            // =========================
            if ($state === 'admin_message_menu') {
                // مطابق درخواست: 2 دکمه «پیام همگانی» و «پیام خصوصی»
                if (in_array($text, ['پیام خصوصی', 'پیغام خصوصی'], true)) {
                    clearState($chat_id);
                    setState($chat_id, 'admin_private_wait_chatid');
                    sendMessage(
                        $chat_id,
                        "👤 <b>پیام خصوصی</b>\n\nایدی عددی کاربر یا یوزرنیم کاربری که می‌خواهید پیام فقط برای او ارسال شود را وارد کنید:\n\nمثال: <code>5191609894</code> یا <code>@username</code>",
                        ['remove_keyboard' => true]
                    );
                    return;
                }

                if (in_array($text, ['پیام همگانی', 'پیغام همگانی'], true)) {
                    clearState($chat_id);
                    setState($chat_id, 'admin_broadcast_wait_message');
                    sendMessage(
                        $chat_id,
                        "🌍 <b>پیام همگانی</b>\n\nپیام خود را بنویسید:",
                        ['remove_keyboard' => true]
                    );
                    return;
                }

                sendMessage($chat_id, "نوع ارسال را انتخاب کنید:", adminMessageMenuKeyboard());
                return;
            }

            // دریافت chat_id برای پیغام خصوصی
            if ($state === 'admin_private_wait_chatid') {
                $raw = trim((string)$text);
                $pdo = db();

                $u = null;
                $targetChat = 0;

                // 1) اگر عددی بود: می‌تواند chat_id یا user_id دیتابیس باشد
                $rawNoSpace = preg_replace('/\s+/', '', $raw);
                if ($rawNoSpace !== '' && preg_match('/^[0-9]+$/', $rawNoSpace)) {
                    $idOrChat = (int)$rawNoSpace;

                    // اول chat_id، اگر نبود user_id
                    try {
                        $q = $pdo->prepare("SELECT id, chat_id, username, first_name, last_name FROM users WHERE chat_id=? LIMIT 1");
                        $q->execute([$idOrChat]);
                        $u = $q->fetch();
                    } catch (Throwable $e) {
                        $u = null;
                    }

                    if (!$u) {
                        try {
                            $q = $pdo->prepare("SELECT id, chat_id, username, first_name, last_name FROM users WHERE id=? LIMIT 1");
                            $q->execute([$idOrChat]);
                            $u = $q->fetch();
                        } catch (Throwable $e) {
                            $u = null;
                        }
                    }

                    if (!empty($u)) {
                        $targetChat = (int)$u['chat_id'];
                    } else {
                        // حتی اگر در دیتابیس نبود، باز هم تلاش می‌کنیم با همین عدد پیام ارسال شود
                        $targetChat = $idOrChat;
                    }
                } else {
                    // 2) اگر یوزرنیم بود
                    $uname = $raw;
                    if ($uname !== '' && $uname[0] === '@') {
                        $uname = trim(substr($uname, 1));
                    }

                    if ($uname === '') {
                        sendMessage($chat_id, "❌ ورودی نامعتبر است. لطفاً آیدی عددی یا یوزرنیم را وارد کنید.", ['remove_keyboard' => true]);
                        return;
                    }

                    try {
                        $q = $pdo->prepare("SELECT id, chat_id, username, first_name, last_name FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    } catch (Throwable $e) {
                        $u = null;
                    }

                    if (empty($u)) {
                        sendMessage(
                            $chat_id,
                            "❌ این یوزرنیم در دیتابیس پیدا نشد.\n\n⚠️ توجه: ربات فقط می‌تواند به کاربرانی پیام بدهد که قبلاً ربات را /start کرده باشند.\n\nلطفاً آیدی عددی (chat_id) را وارد کنید:",
                            ['remove_keyboard' => true]
                        );
                        return;
                    }

                    $targetChat = (int)$u['chat_id'];
                }

                if ($targetChat < 1) {
                    sendMessage(
                        $chat_id,
                        "❌ آیدی/یوزرنیم نامعتبر است. لطفاً دوباره وارد کنید:",
                        ['remove_keyboard' => true]
                    );
                    return;
                }

                $d = [
                    'target_chat_id' => $targetChat,
                    'target_user_id' => (int)($u['id'] ?? 0),
                    'target_username' => (string)($u['username'] ?? ''),
                    'target_first_name' => (string)($u['first_name'] ?? ''),
                    'target_last_name' => (string)($u['last_name'] ?? ''),
                ];

                setState($chat_id, 'admin_private_wait_message', $d);

                $who = "chat_id: <code>{$targetChat}</code>";
                if (!empty($u)) {
                    $uname2 = !empty($u['username']) ? ('@' . $u['username']) : '—';
                    $full = trim((string)($u['first_name'] ?? '') . ' ' . (string)($u['last_name'] ?? ''));
                    if ($full === '') $full = '—';
                    $who = "کاربر: <b>" . htmlspecialchars($full) . "</b> | {$uname2}\n" . $who;
                } else {
                    $who .= "\n⚠️ این کاربر در دیتابیس پیدا نشد (اگر کاربر /start نکرده باشد، ارسال ممکن است ناموفق شود).";
                }

                sendMessage(
                    $chat_id,
                    "✅ دریافت شد.\n\n{$who}\n\nحالا پیام خود را بنویسید:",
                    ['remove_keyboard' => true]
                );
                return;
            }

            // دریافت پیام برای ارسال خصوصی
            if ($state === 'admin_private_wait_message') {
                $targetChat = (int)($data['target_chat_id'] ?? 0);
                $targetUserId = (int)($data['target_user_id'] ?? 0);

                if ($targetChat < 1) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا: chat_id مقصد نامعتبر است.", adminMenuKeyboard());
                    return;
                }

                $srcMid = (int)($m['message_id'] ?? 0);
                if ($srcMid < 1) {
                    sendMessage($chat_id, "❌ خطا: پیام قابل ارسال نیست. دوباره تلاش کنید.", adminMessageMenuKeyboard());
                    return;
                }

                $res = copyMessage($targetChat, $chat_id, $srcMid);

                // مدیریت 429
                if ($res && empty($res['ok']) && (int)($res['error_code'] ?? 0) === 429) {
                    $retry = (int)($res['parameters']['retry_after'] ?? 1);
                    if ($retry > 0 && $retry < 60) {
                        sleep($retry);
                    } else {
                        usleep(500000);
                    }
                    $res = copyMessage($targetChat, $chat_id, $srcMid);
                }

                $ok = ($res && !empty($res['ok']));
                if (!$ok) {
                    $errCode = (int)($res['error_code'] ?? 0);
                    $desc = (string)($res['description'] ?? '');

                    // اگر کاربر بلاک کرده باشد
                    if ($targetUserId > 0 && ($errCode === 403 || stripos($desc, 'blocked by the user') !== false || stripos($desc, 'user is deactivated') !== false || stripos($desc, 'chat not found') !== false)) {
                        $pdo = db();
                        $pdo->prepare("UPDATE users SET is_blocked=1 WHERE id=?")->execute([$targetUserId]);
                    }

                    clearState($chat_id);
                    sendMessage(
                        $chat_id,
                        "❌ ارسال پیام ناموفق بود.\nchat_id مقصد: <code>{$targetChat}</code>\nخطا: <code>{$errCode}</code>\n" . htmlspecialchars($desc),
                        adminMenuKeyboard()
                    );
                    return;
                }

                clearState($chat_id);
                sendMessage(
                    $chat_id,
                    "✅ پیام با موفقیت ارسال شد.\nchat_id مقصد: <code>{$targetChat}</code>",
                    adminMenuKeyboard()
                );
                return;
            }

            // دریافت پیام برای ارسال همگانی (ارسال مستقیم)
            if ($state === 'admin_broadcast_wait_message') {
                @set_time_limit(0);
                ignore_user_abort(true);

                $srcMid = (int)($m['message_id'] ?? 0);
                if ($srcMid < 1) {
                    sendMessage($chat_id, "❌ خطا: پیام قابل ارسال نیست. دوباره تلاش کنید.", adminMessageMenuKeyboard());
                    return;
                }

                $pdo = db();
                $total = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE is_blocked=0")->fetchColumn();
                if ($total < 1) {
                    clearState($chat_id);
                    sendMessage($chat_id, "— کاربری برای ارسال همگانی وجود ندارد —", adminMenuKeyboard());
                    return;
                }

                // پیام شروع + نگه داشتن message_id برای آپدیت وضعیت
                $start = sendMessage($chat_id, "⏳ شروع ارسال همگانی...\n\nکل کاربران هدف: <b>{$total}</b>", adminMenuKeyboard());
                $progressMid = (int)($start['result']['message_id'] ?? 0);

                $sent = 0;
                $failed = 0;
                $blocked = 0;
                $lastError = null;

                $batchSize = 2000; // برای جلوگیری از مصرف زیاد حافظه
                $lastId = 0;
                $sleepUs = 120000; // کمی تاخیر برای کاهش ریت‌لیمیت

                while (true) {
                    $stmt = $pdo->prepare("SELECT id, chat_id FROM users WHERE is_blocked=0 AND id > ? ORDER BY id ASC LIMIT {$batchSize}");
                    $stmt->execute([$lastId]);
                    $targets = $stmt->fetchAll();
                    if (!$targets) break;

                    foreach ($targets as $t) {
                        $uid = (int)$t['id'];
                        $cid = (int)$t['chat_id'];
                        $lastId = $uid;

                        $res = copyMessage($cid, $chat_id, $srcMid);

                        // مدیریت 429
                        if ($res && empty($res['ok']) && (int)($res['error_code'] ?? 0) === 429) {
                            $retry = (int)($res['parameters']['retry_after'] ?? 1);
                            if ($retry > 0 && $retry < 60) {
                                sleep($retry);
                            } else {
                                usleep(500000);
                            }
                            $res = copyMessage($cid, $chat_id, $srcMid);
                        }

                        if ($res && !empty($res['ok'])) {
                            $sent++;
                        } else {
                            $failed++;
                            $errCode = (int)($res['error_code'] ?? 0);
                            $desc = (string)($res['description'] ?? '');
                            $lastError = "{$errCode}: {$desc}";

                            if ($errCode === 403 || stripos($desc, 'blocked by the user') !== false || stripos($desc, 'user is deactivated') !== false || stripos($desc, 'chat not found') !== false) {
                                $pdo->prepare("UPDATE users SET is_blocked=1 WHERE id=?")->execute([$uid]);
                                $blocked++;
                            }
                        }

                        // هر 50 نفر یکبار گزارش پیشرفت
                        if ($progressMid > 0 && (($sent + $failed) % 50) === 0) {
                            $done = $sent + $failed;
                            editMessageText($chat_id, $progressMid, "⏳ در حال ارسال...\n\nپیشرفت: <b>{$done}</b> از <b>{$total}</b>\nموفق: <b>{$sent}</b>\nناموفق: <b>{$failed}</b>");
                        }

                        usleep($sleepUs);
                    }
                }

                $report = "✅ ارسال همگانی انجام شد.\n\n";
                $report .= "کل کاربران هدف: <b>{$total}</b>\n";
                $report .= "ارسال موفق: <b>{$sent}</b>\n";
                $report .= "ناموفق: <b>{$failed}</b>\n";
                $report .= "بلاک‌شده‌ها (شناسایی‌شده): <b>{$blocked}</b>";
                if (!empty($lastError)) {
                    $report .= "\n\nآخرین خطا: <code>" . htmlspecialchars($lastError) . "</code>";
                }

                clearState($chat_id);

                if ($progressMid > 0) {
                    editMessageText($chat_id, $progressMid, $report, adminMenuKeyboard());
                } else {
                    sendMessage($chat_id, $report, adminMenuKeyboard());
                }
                return;
            }

            // =========================
            // زیرمنوی شارژ کیف پول
            // =========================
            if ($state === 'admin_wallet_topup_menu') {
                if ($text === '👤 شارژ کاربر تکی') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_wallet_charge_user_wait_target');
                    sendMessage(
                        $chat_id,
                        "💰 شارژ کیف پول (تکی)\n\nلطفاً یکی از موارد زیر را ارسال کنید:\n• <b>user_id</b>\n• <b>chat_id</b>\n• <b>@username</b>\n\nبرای لغو: 🔙 بازگشت",
                        adminWalletTopupMenuKeyboard()
                    );
                    return;
                }

                if ($text === '🌍 شارژ همگانی') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_wallet_bulk_wait_amount');
                    sendMessage(
                        $chat_id,
                        "🌍 شارژ همگانی کیف پول\n\nلطفاً مبلغ شارژ برای <b>همه کاربران</b> را به تومان ارسال کنید (فقط عدد).\n\nبرای لغو: 🔙 بازگشت",
                        adminWalletTopupMenuKeyboard()
                    );
                    return;
                }

                // اگر چیز دیگری زد، دوباره همان منو را نمایش بده
                sendMessage($chat_id, "نوع شارژ را انتخاب کنید:", adminWalletTopupMenuKeyboard());
                return;
            }



            // =========================
            // 👥 مدیریت کاربران (زیرمنو)
            // =========================
            if ($state === 'admin_users_manage_menu') {
                if ($text === 'کاربران') {
                    // نمایش لیست کاربران (بدون دکمه‌های مسدود/رفع مسدود)
                    $p = adminUsersListPayload(1, 20);
                    sendMessage($chat_id, $p['text'], $p['kb']);
                    return;
                }

                if ($text === 'مسدود/فعال کردن') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_users_block_menu');
                    $msg = adminBlockedUsersListText(100);
                    sendMessage($chat_id, $msg, adminUsersBlockActionsKeyboard());
                    return;
                }

                sendMessage($chat_id, "یکی از گزینه‌ها را انتخاب کنید:", adminUsersManageMenuKeyboard());
                return;
            }

            // =========================
            // ⛔️ کاربران مسدود: منوی عملیات
            // =========================
            if ($state === 'admin_users_block_menu') {
                if ($text === '✅ فعالسازی') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_users_unblock_wait_identifier');
                    sendMessage(
                        $chat_id,
                        "✅ فعالسازی کاربر

آیدی عددی (chat_id یا user_id) یا یوزرنیم را وارد کنید:
مثال: <code>5419341878</code> یا <code>@username</code>

برای لغو: 🔙 بازگشت",
                        adminUsersBlockActionsKeyboard()
                    );
                    return;
                }

                if ($text === '⛔️ مسدود سازی') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_users_block_wait_identifier');
                    sendMessage(
                        $chat_id,
                        "⛔️ مسدود سازی کاربر

آیدی عددی (chat_id یا user_id) یا یوزرنیم را وارد کنید:
مثال: <code>5419341878</code> یا <code>@username</code>

برای لغو: 🔙 بازگشت",
                        adminUsersBlockActionsKeyboard()
                    );
                    return;
                }

                $msg = adminBlockedUsersListText(100);
                sendMessage($chat_id, $msg, adminUsersBlockActionsKeyboard());
                return;
            }

            // =========================
            // ✅ فعالسازی: دریافت آیدی/یوزرنیم
            // =========================
            if ($state === 'admin_users_unblock_wait_identifier') {
                $raw = trim((string)$text);
                $pdo = db();

                $u = null;
                // username با @
                if ($raw !== '' && $raw[0] === '@') {
                    $uname = trim(substr($raw, 1));
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                // عددی (chat_id یا user_id)
                if (!$u) {
                    $num = preg_replace('/[^0-9]/', '', $raw);
                    $idOrChat = (int)$num;
                    if ($idOrChat > 0) {
                        $q = $pdo->prepare("SELECT * FROM users WHERE chat_id=? LIMIT 1");
                        $q->execute([$idOrChat]);
                        $u = $q->fetch();

                        if (!$u) {
                            $q = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
                            $q->execute([$idOrChat]);
                            $u = $q->fetch();
                        }
                    }
                }

                // username بدون @
                if (!$u && $raw !== '' && !ctype_digit($raw)) {
                    $uname = trim($raw);
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                if (!$u) {
                    sendMessage(
                        $chat_id,
                        "❌ کاربر پیدا نشد. لطفاً آیدی عددی یا @username صحیح ارسال کنید.

برای لغو: 🔙 بازگشت",
                        adminUsersBlockActionsKeyboard()
                    );
                    return;
                }

                $uid = (int)$u['id'];
                $pdo->prepare("UPDATE users SET is_blocked=0 WHERE id=?")->execute([$uid]);

                clearState($chat_id);
                setState($chat_id, 'admin_users_block_menu');

                $uname = !empty($u['username']) ? ('@' . $u['username']) : '—';
                $full = trim((string)($u['first_name'] ?? '') . ' ' . (string)($u['last_name'] ?? ''));
                if ($full === '') $full = '—';

                $msg = "✅ کاربر فعال شد و می‌تواند از خدمات ربات استفاده کند.

";
                $msg .= "کاربر: <b>" . htmlspecialchars($full) . "</b> | {$uname}
";
                $msg .= "chat_id: <code>" . (int)$u['chat_id'] . "</code> | user_id: <code>" . (int)$u['id'] . "</code>

";
                $msg .= adminBlockedUsersListText(100);

                sendMessage($chat_id, $msg, adminUsersBlockActionsKeyboard());
                return;
            }

            // =========================
            // ⛔️ مسدود سازی: دریافت آیدی/یوزرنیم
            // =========================
            if ($state === 'admin_users_block_wait_identifier') {
                $raw = trim((string)$text);
                $pdo = db();

                $u = null;
                // username با @
                if ($raw !== '' && $raw[0] === '@') {
                    $uname = trim(substr($raw, 1));
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                // عددی (chat_id یا user_id)
                if (!$u) {
                    $num = preg_replace('/[^0-9]/', '', $raw);
                    $idOrChat = (int)$num;
                    if ($idOrChat > 0) {
                        $q = $pdo->prepare("SELECT * FROM users WHERE chat_id=? LIMIT 1");
                        $q->execute([$idOrChat]);
                        $u = $q->fetch();

                        if (!$u) {
                            $q = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
                            $q->execute([$idOrChat]);
                            $u = $q->fetch();
                        }
                    }
                }

                // username بدون @
                if (!$u && $raw !== '' && !ctype_digit($raw)) {
                    $uname = trim($raw);
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                if (!$u) {
                    sendMessage(
                        $chat_id,
                        "❌ کاربر پیدا نشد. لطفاً آیدی عددی یا @username صحیح ارسال کنید.

برای لغو: 🔙 بازگشت",
                        adminUsersBlockActionsKeyboard()
                    );
                    return;
                }

                $uid = (int)$u['id'];
                $pdo->prepare("UPDATE users SET is_blocked=1 WHERE id=?")->execute([$uid]);

                clearState($chat_id);
                setState($chat_id, 'admin_users_block_menu');

                $uname = !empty($u['username']) ? ('@' . $u['username']) : '—';
                $full = trim((string)($u['first_name'] ?? '') . ' ' . (string)($u['last_name'] ?? ''));
                if ($full === '') $full = '—';

                $msg = "⛔️ کاربر مسدود شد و دیگر نمی‌تواند از خدمات ربات استفاده کند.

";
                $msg .= "کاربر: <b>" . htmlspecialchars($full) . "</b> | {$uname}
";
                $msg .= "chat_id: <code>" . (int)$u['chat_id'] . "</code> | user_id: <code>" . (int)$u['id'] . "</code>

";
                $msg .= adminBlockedUsersListText(100);

                sendMessage($chat_id, $msg, adminUsersBlockActionsKeyboard());
                return;
            }

            // =========================
            // شارژ کیف پول توسط ادمین (کاربر مشخص)
            // =========================
            if ($state === 'admin_wallet_charge_user_wait_target') {
                $raw = trim((string)$text);
                $pdo = db();

                $u = null;
                // username
                if ($raw !== '' && $raw[0] === '@') {
                    $uname = trim(substr($raw, 1));
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                // عددی (chat_id یا user_id)
                if (!$u) {
                    $num = preg_replace('/[^0-9]/', '', $raw);
                    $idOrChat = (int)$num;
                    if ($idOrChat > 0) {
                        // اول chat_id، اگر نبود user_id
                        $q = $pdo->prepare("SELECT * FROM users WHERE chat_id=? LIMIT 1");
                        $q->execute([$idOrChat]);
                        $u = $q->fetch();

                        if (!$u) {
                            $q = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
                            $q->execute([$idOrChat]);
                            $u = $q->fetch();
                        }
                    }
                }

                // username بدون @
                if (!$u && $raw !== '' && !ctype_digit($raw)) {
                    $uname = trim($raw);
                    if ($uname !== '') {
                        $q = $pdo->prepare("SELECT * FROM users WHERE username=? LIMIT 1");
                        $q->execute([$uname]);
                        $u = $q->fetch();
                    }
                }

                if (!$u) {
                    sendMessage(
                        $chat_id,
                        "❌ کاربر پیدا نشد. لطفاً <b>user_id</b> یا <b>chat_id</b> یا <b>@username</b> صحیح ارسال کنید.\n\nبرای لغو: 🔙 بازگشت",
                        adminWalletTopupMenuKeyboard()
                    );
                    return;
                }

                $data = [
                    'user_id' => (int)$u['id'],
                    'chat_id' => (int)$u['chat_id'],
                    'username' => (string)($u['username'] ?? ''),
                    'first_name' => (string)($u['first_name'] ?? ''),
                    'last_name' => (string)($u['last_name'] ?? ''),
                ];

                setState($chat_id, 'admin_wallet_charge_user_wait_amount', $data);

                $uname = !empty($u['username']) ? ('@' . $u['username']) : '—';
                $full = trim((string)($u['first_name'] ?? '') . ' ' . (string)($u['last_name'] ?? ''));
                if ($full === '') $full = '—';

                $msg = "💰 شارژ کیف پول کاربر\n\n";
                $msg .= "کاربر: <b>" . htmlspecialchars($full) . "</b> | {$uname}\n";
                $msg .= "chat_id: <code>" . (int)$u['chat_id'] . "</code> | user_id: <code>" . (int)$u['id'] . "</code>\n\n";
                $msg .= "لطفاً مبلغ شارژ را به تومان ارسال کنید (فقط عدد).\nمثال: <code>100000</code>";

                sendMessage($chat_id, $msg, adminWalletTopupMenuKeyboard());
                return;
            }

            if ($state === 'admin_wallet_charge_user_wait_amount') {
                $raw = (string)$text;
                $num = preg_replace('/[^0-9]/', '', $raw);
                $amount = (int)$num;

                if ($amount < 1000) {
                    sendMessage($chat_id, "❌ مبلغ نامعتبر است. لطفاً فقط عدد و حداقل 1000 تومان ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminWalletTopupMenuKeyboard());
                    return;
                }

                $uid = (int)($data['user_id'] ?? 0);
                $toChat = (int)($data['chat_id'] ?? 0);

                if ($uid < 1 || $toChat < 1) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا در اطلاعات کاربر. دوباره تلاش کنید.", adminMenuKeyboard());
                    return;
                }

                $cred = walletCredit($uid, $amount, null, null, ['kind' => 'admin_charge', 'by' => 'admin', 'admin_chat_id' => $chat_id]);
                if (empty($cred['ok'])) {
                    sendMessage($chat_id, "❌ افزایش موجودی ناموفق بود. دوباره تلاش کنید.", adminWalletTopupMenuKeyboard());
                    return;
                }

                // اطلاع به کاربر
                $msgU = "💰 کیف پول شما از طرف ادمین شارژ شد.\n\n";
                $msgU .= "مبلغ: <b>" . formatToman($amount) . " تومان</b>\n";
                $msgU .= "موجودی جدید: <b>" . formatToman((int)($cred['balance'] ?? 0)) . " تومان</b>";
                $send = sendMessage($toChat, $msgU, userMenuKeyboard());

                // اگر کاربر بلاک کرده باشد
                if ($send && empty($send['ok'])) {
                    $errCode = (int)($send['error_code'] ?? 0);
                    $desc = (string)($send['description'] ?? '');
                    if ($errCode === 403 || stripos($desc, 'blocked by the user') !== false || stripos($desc, 'user is deactivated') !== false || stripos($desc, 'chat not found') !== false) {
                        $pdo = db();
                        $pdo->prepare("UPDATE users SET is_blocked=1 WHERE id=?")->execute([$uid]);
                    }
                }

                clearState($chat_id);
                sendMessage($chat_id, "✅ شارژ انجام شد.\nموجودی جدید کاربر: <b>" . formatToman((int)($cred['balance'] ?? 0)) . " تومان</b>", adminMenuKeyboard());
                return;
            }

            // =========================
            // شارژ همگانی (Bulk) - توسط Cron
            // =========================
            if ($state === 'admin_wallet_bulk_wait_amount') {
                $raw = (string)$text;
                $num = preg_replace('/[^0-9]/', '', $raw);
                $amount = (int)$num;

                if ($amount < 1000) {
                    sendMessage($chat_id, "❌ مبلغ نامعتبر است. لطفاً فقط عدد و حداقل 1000 تومان ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminWalletTopupMenuKeyboard());
                    return;
                }

                $pdo = db();
                $now = time();

                if (!walletBulkCreditsTableExists()) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ قابلیت شارژ همگانی هنوز روی دیتابیس نصب نشده است.\nلطفاً اسکریپت آپدیت دیتابیس را اجرا کنید.", adminMenuKeyboard());
                    return;
                }

                $stmt = $pdo->prepare("INSERT INTO wallet_bulk_credits (admin_chat_id, amount_toman, status, created_at) VALUES (?,?, 'pending', ?)");
                $stmt->execute([$chat_id, $amount, $now]);
                $jid = (int)$pdo->lastInsertId();

                clearState($chat_id);
                sendMessage($chat_id, "✅ شارژ همگانی ثبت شد.\n\n🕒 انجام شارژ و ارسال پیام توسط <b>cron.php</b> انجام می‌شود.\nشناسه: #{$jid}", adminMenuKeyboard());
                return;
            }



            // =========================
            // مدیریت کد تخفیف (Discount Admin)
            // =========================
            if ($state === 'admin_discount_menu') {
                

                if ($text === '🎯 گروه خاص') {
                    if (!planGroupsTableExists()) {
                        sendMessage($chat_id, "⚠️ جدول plan_groups در دیتابیس وجود ندارد.", adminDiscountMenuKeyboard());
                        return;
                    }

                    $groups = listPlanGroupsAll();
                    if (!$groups) {
                        sendMessage($chat_id, "ℹ️ گروهی وجود ندارد.", adminDiscountMenuKeyboard());
                        return;
                    }

                    $map = getDiscountGroupMap();

                    $ik = [];
                    foreach ($groups as $g) {
                        $key = (string)($g['group_key'] ?? '');
                        if ($key === '') continue;
                        $title = (string)($g['title'] ?? $key);
                        $active = (int)($g['active'] ?? 1);
                        $tag = $active ? '✅' : '⛔️';
                        $has = isset($map[strtolower($key)]) ? ' 🎟' : '';
                        $ik[] = [[
                            'text' => $tag . ' ' . $title . $has,
                            'callback_data' => 'admin:discount:group_select:' . $key,
                        ]];
                    }
                    $ik[] = [[
                        'text' => '⬅️ بازگشت',
                        'callback_data' => 'admin:discount:back_to_menu',
                    ]];

                    sendMessage($chat_id, "🎯 <b>گروه خاص</b>

یک گروه را انتخاب کنید:", ['inline_keyboard' => $ik]);
                    return;
                }
if ($text === '➕ افزودن کد تخفیف') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_disc_add_code');
                    sendMessage($chat_id, "➕ افزودن کد تخفیف\n\nلطفاً کد تخفیف را ارسال کنید (انگلیسی/عدد، بدون فاصله).\nمثال: <code>OFF50</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                if ($text === '⏳ انقضای کد تخفیف') {
                    $codes = listDiscountCodesAll();
                    if (!$codes) {
                        sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
                        return;
                    }
                    clearState($chat_id);
                    setState($chat_id, 'admin_disc_exp_select_code');
                    sendMessage($chat_id, "⏳ انتخاب کد برای تنظیم تاریخ شروع/انقضا\n\nیک کد را انتخاب کنید:", adminDiscountCodesKeyboard($codes));
                    return;
                }

                if ($text === '👤 کد تخفیف اختصاصی') {
                    $codes = listDiscountCodesAll();
                    if (!$codes) {
                        sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
                        return;
                    }
                    clearState($chat_id);
                    setState($chat_id, 'admin_disc_user_wait_userid');
                    sendMessage($chat_id, "👤 اختصاصی کردن کد تخفیف\n\nلطفاً <b>user_id</b> عددی کاربر را ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                if ($text === '🌍 کد تخفیف همگانی') {
                    $codes = listDiscountCodesAll();
                    if (!$codes) {
                        sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
                        return;
                    }
                    clearState($chat_id);
                    setState($chat_id, 'admin_disc_global_select_code');
                    sendMessage($chat_id, "🌍 همگانی کردن کد تخفیف\n\nیک کد را انتخاب کنید:", adminDiscountCodesKeyboard($codes));
                    return;
                }

                if ($text === '📋 نمایش کدهای تخفیف') {
                    $codes = listDiscountCodesAll();
                    if (!$codes) {
                        sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
                        return;
                    }

                    $now = time();
                    $active = [];
                    $expired = [];
                    foreach ($codes as $c) {
                        $isExpired = (!empty($c['expires_at']) && (int)$c['expires_at'] > 0 && (int)$c['expires_at'] < $now);
                        if ((int)($c['active'] ?? 0) === 1 && !$isExpired) $active[] = $c;
                        else $expired[] = $c;
                    }

                    $msg = "🎟 لیست کدهای تخفیف\n\n";
                    $msg .= "✅ فعال:\n";
                    if (!$active) {
                        $msg .= "— ندارد —\n";
                    } else {
                        foreach (array_slice($active, 0, 30) as $c) {
                            $scope = ((int)($c['user_id'] ?? 0) > 0) ? ("اختصاصی user_id=" . (int)$c['user_id']) : "همگانی";
                            $type = ((string)$c['type'] === 'fixed') ? ("مبلغ " . formatToman((int)$c['value']) . "ت") : ("٪" . (int)$c['value']);
                            $st = !empty($c['starts_at']) ? jdate_from_timestamp((int)$c['starts_at']) : '—';
                            $ex = !empty($c['expires_at']) ? jdate_from_timestamp((int)$c['expires_at']) : '—';
                            $msg .= "• <code>" . htmlspecialchars((string)$c['code']) . "</code> | {$type} | {$scope}\n";
                            $msg .= "  شروع: {$st} | انقضا: {$ex}\n";
                        }
                    }

                    $msg .= "\n⛔️ غیرفعال/منقضی:\n";
                    if (!$expired) {
                        $msg .= "— ندارد —\n";
                    } else {
                        foreach (array_slice($expired, 0, 30) as $c) {
                            $scope = ((int)($c['user_id'] ?? 0) > 0) ? ("اختصاصی user_id=" . (int)$c['user_id']) : "همگانی";
                            $type = ((string)$c['type'] === 'fixed') ? ("مبلغ " . formatToman((int)$c['value']) . "ت") : ("٪" . (int)$c['value']);
                            $st = !empty($c['starts_at']) ? jdate_from_timestamp((int)$c['starts_at']) : '—';
                            $ex = !empty($c['expires_at']) ? jdate_from_timestamp((int)$c['expires_at']) : '—';
                            $msg .= "• <code>" . htmlspecialchars((string)$c['code']) . "</code> | {$type} | {$scope}\n";
                            $msg .= "  شروع: {$st} | انقضا: {$ex}\n";
                        }
                    }

                    sendMessage($chat_id, $msg, adminDiscountMenuKeyboard());
                    return;
                }

                if ($text === '🗑 حذف کد تخفیف') {
                    $codes = listDiscountCodesAll();
                    if (!$codes) {
                        sendMessage($chat_id, "— هیچ کد تخفیفی ثبت نشده است —", adminDiscountMenuKeyboard());
                        return;
                    }
                    clearState($chat_id);
                    setState($chat_id, 'admin_disc_delete_select_code');
                    sendMessage($chat_id, "🗑 حذف کد تخفیف\n\nیک کد را برای حذف انتخاب کنید یا «حذف همه» را بزنید:", adminDiscountCodesKeyboardWithDeleteAll($codes));
                    return;
                }

                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    sendMessage($chat_id, "👑 پنل ادمین\n\nیکی از گزینه‌های زیر را انتخاب کنید:", adminMenuKeyboard());
                    return;
                }

                sendMessage($chat_id, "یک گزینه را انتخاب کنید:", adminDiscountMenuKeyboard());
                return;
            }

            // ---- افزودن کد: دریافت کد ----
            if ($state === 'admin_disc_add_code') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $code = normalizeDiscountCode((string)$text);
                if ($code === '' || mb_strlen($code) > 50) {
                    sendMessage($chat_id, "❌ کد نامعتبر است. یک کد کوتاه (حداکثر 50 کاراکتر) بدون فاصله ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                // انتخاب نوع
                setState($chat_id, 'admin_disc_add_type', ['code' => $code]);
                $kb = [
                    'keyboard' => [
                        [['text' => '٪ درصدی'], ['text' => '💰 مبلغ ثابت']],
                        [['text' => '🔙 بازگشت']],
                    ],
                    'resize_keyboard' => true
                ];
                sendMessage($chat_id, "نوع تخفیف را انتخاب کنید:", $kb);
                return;
            }

            // ---- افزودن کد: نوع ----
            if ($state === 'admin_disc_add_type') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $type = null;
                if ($text === '٪ درصدی') $type = 'percent';
                if ($text === '💰 مبلغ ثابت') $type = 'fixed';

                if (!$type) {
                    sendMessage($chat_id, "لطفاً نوع را از دکمه‌ها انتخاب کنید.", [
                        'keyboard' => [
                            [['text' => '٪ درصدی'], ['text' => '💰 مبلغ ثابت']],
                            [['text' => '🔙 بازگشت']],
                        ],
                        'resize_keyboard' => true
                    ]);
                    return;
                }

                $d = $data;
                $d['type'] = $type;
                setState($chat_id, 'admin_disc_add_value', $d);
                $msg = ($type === 'percent')
                    ? "مقدار تخفیف را به صورت درصد ارسال کنید (فقط عدد).\nمثال: <code>15</code>"
                    : "مقدار تخفیف را به تومان ارسال کنید (فقط عدد).\nمثال: <code>50000</code>";
                sendMessage($chat_id, $msg . "\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                return;
            }

            // ---- افزودن کد: مقدار ----
            if ($state === 'admin_disc_add_value') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $num = (int)preg_replace('/[^0-9]/', '', (string)$text);
                if ($num <= 0) {
                    sendMessage($chat_id, "❌ مقدار نامعتبر است. فقط عدد ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                if (($data['type'] ?? '') === 'percent' && ($num < 1 || $num > 100)) {
                    sendMessage($chat_id, "❌ درصد باید بین 1 تا 100 باشد.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                $d = $data;
                $d['value'] = $num;
                setState($chat_id, 'admin_disc_add_maxuses', $d);
                sendMessage($chat_id, "حداکثر تعداد استفاده را ارسال کنید (0 = نامحدود).\nمثال: <code>0</code> یا <code>50</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                return;
            }

            // ---- افزودن کد: max_uses و ذخیره ----
            if ($state === 'admin_disc_add_maxuses') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $max = (int)preg_replace('/[^0-9]/', '', (string)$text);
                if ($max < 0) $max = 0;

                $pdo = db();
                $now = time();
                $code = (string)($data['code'] ?? '');
                $type = (string)($data['type'] ?? 'percent');
                $val = (int)($data['value'] ?? 0);

                try {
                    $stmt = $pdo->prepare("INSERT INTO discount_codes (code, title, type, value, max_uses, used_count, starts_at, expires_at, active, user_id, is_global, created_at, updated_at) VALUES (NULLIF(?,''), NULL, ?, ?, ?, 0, NULL, NULL, 1, NULL, 1, ?, ?)");
                    $stmt->execute([$code, $type, $val, $max, $now, $now]);
                } catch (Throwable $e) {
                    $msg = $e->getMessage();
                    $codeSql = (string)$e->getCode();

                    // Duplicate key (کد تکراری)
                    $isDup = ($codeSql === '23000') || (stripos($msg, 'Duplicate') !== false) || (stripos($msg, 'duplicate') !== false);

                    if ($isDup) {
                        // اطلاعات کد موجود
                        $existing = null;
                        try {
                            $q = $pdo->prepare("SELECT id, type, value, max_uses, active, starts_at, expires_at, user_id, is_global FROM discount_codes WHERE code=? LIMIT 1");
                            $q->execute([$code]);
                            $existing = $q->fetch(PDO::FETCH_ASSOC);
                        } catch (Throwable $e2) {}

                        $pending = $data;
                        $pending['code'] = $code;
                        $pending['type'] = $type;
                        $pending['value'] = $val;
                        $pending['max_uses'] = $max;
                        $pending['existing'] = $existing ?: ['code' => $code];

                        clearState($chat_id);
                        setState($chat_id, 'admin_disc_add_upsert_confirm', $pending);

                        $cur = '';
                        if ($existing) {
                            $curType = (($existing['type'] ?? '') === 'fixed') ? 'مبلغ ثابت' : 'درصدی';
                            $curVal  = (int)($existing['value'] ?? 0);
                            $curMax  = (int)($existing['max_uses'] ?? 0);
                            $cur .= "\n\n📌 وضعیت فعلی:\n• نوع: {$curType}\n• مقدار: {$curVal}\n• سقف استفاده: " . ($curMax === 0 ? 'نامحدود' : $curMax);
                        }

                        sendMessage(
                            $chat_id,
                            "⚠️ این کد قبلاً وجود دارد.\nآیا می‌خواهید بروزرسانی شود؟{$cur}\n\n✅ بروزرسانی = جایگزین کردن نوع/مقدار/حداکثر استفاده\n❌ لغو = بدون تغییر",
                            adminDiscountUpsertConfirmKeyboard()
                        );
                        return;
                    }

                    sendMessage($chat_id, "❌ ثبت کد ناموفق بود.\n\nپیغام خطا: <code>" . htmlspecialchars($msg) . "</code>\n\nبرای بازگشت: بازگشت", adminDiscountMenuKeyboard());
}

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ کد تخفیف ثبت شد.\n\nکد: <code>" . htmlspecialchars($code) . "</code>", adminDiscountMenuKeyboard());
                return;
            }

            

// ---- افزودن کد: کد تکراری -> تایید بروزرسانی ----
if ($state === 'admin_disc_add_upsert_confirm') {
    if ($text === 'بازگشت' || $text === '❌ لغو') {
        clearState($chat_id);
        setState($chat_id, 'admin_discount_menu');
        sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
        return;
    }

    if ($text === '✅ بروزرسانی') {
        $pdo = db();
        $now = time();
        $code = (string)($data['code'] ?? '');
        $type = (string)($data['type'] ?? 'percent');
        $val  = (int)($data['value'] ?? 0);
        $max  = (int)($data['max_uses'] ?? 0);
        if ($max < 0) $max = 0;

        try {
            $st = $pdo->prepare("UPDATE discount_codes
                                 SET type=?, value=?, max_uses=?, active=1, updated_at=?
                                 WHERE code=? LIMIT 1");
            $st->execute([$type, $val, $max, $now, $code]);
        } catch (Throwable $e) {
            sendMessage($chat_id, "❌ بروزرسانی ناموفق بود.\n\nپیغام خطا: <code>" . htmlspecialchars($e->getMessage()) . "</code>", adminDiscountMenuKeyboard());
            return;
        }

        clearState($chat_id);
        setState($chat_id, 'admin_discount_menu');
        sendMessage($chat_id, "✅ بروزرسانی انجام شد.\n\nکد: <code>" . htmlspecialchars($code) . "</code>", adminDiscountMenuKeyboard());
        return;
    }

    sendMessage($chat_id, "یکی از گزینه‌ها را انتخاب کنید:", adminDiscountUpsertConfirmKeyboard());
    return;
}

// ---- انقضا: انتخاب کد ----
            if ($state === 'admin_disc_exp_select_code') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $row = getDiscountCodeRow((string)$text);
                if (!$row) {
                    sendMessage($chat_id, "❌ کد پیدا نشد. از لیست انتخاب کنید.", adminDiscountMenuKeyboard());
                    return;
                }

                setState($chat_id, 'admin_disc_exp_wait_start', ['code_id' => (int)$row['id'], 'code' => (string)$row['code']]);
                sendMessage($chat_id, "تاریخ شروع را وارد کنید (YYYY-MM-DD)\nمثال: <code>2025-12-26</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                return;
            }

            // ---- انقضا: دریافت شروع ----
            if ($state === 'admin_disc_exp_wait_start') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $ts = parseDateToTimestamp((string)$text, false);
                if (!$ts) {
                    sendMessage($chat_id, "❌ فرمت تاریخ نامعتبر است.\nمثال صحیح: <code>2025-12-26</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                $d = $data;
                $d['starts_at'] = $ts;
                setState($chat_id, 'admin_disc_exp_wait_end', $d);
                sendMessage($chat_id, "تاریخ انقضا را وارد کنید (YYYY-MM-DD)\nمثال: <code>2026-01-10</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                return;
            }

            // ---- انقضا: دریافت پایان و ذخیره ----
            if ($state === 'admin_disc_exp_wait_end') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $end = parseDateToTimestamp((string)$text, true);
                if (!$end) {
                    sendMessage($chat_id, "❌ فرمت تاریخ نامعتبر است.\nمثال صحیح: <code>2026-01-10</code>\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                $codeId = (int)($data['code_id'] ?? 0);
                $start = (int)($data['starts_at'] ?? 0);
                if ($codeId < 1 || $start < 1) {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "❌ خطا در اطلاعات. دوباره تلاش کنید.", adminDiscountMenuKeyboard());
                    return;
                }

                if ($end <= $start) {
                    sendMessage($chat_id, "❌ تاریخ انقضا باید بعد از تاریخ شروع باشد.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                $pdo = db();
                $pdo->prepare("UPDATE discount_codes SET starts_at=?, expires_at=? WHERE id=?")->execute([$start, $end, $codeId]);

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ تاریخ شروع/انقضا ذخیره شد.\nکد: <code>" . htmlspecialchars((string)($data['code'] ?? '')) . "</code>", adminDiscountMenuKeyboard());
                return;
            }

            // ---- اختصاصی: دریافت user_id ----
            if ($state === 'admin_disc_user_wait_userid') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $uid = (int)preg_replace('/[^0-9]/', '', (string)$text);
                if ($uid < 1) {
                    sendMessage($chat_id, "❌ user_id نامعتبر است. فقط عدد ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                // بررسی وجود کاربر
                $pdo = db();
                $q = $pdo->prepare("SELECT id FROM users WHERE id=? LIMIT 1");
                $q->execute([$uid]);
                $urow = $q->fetch();
                if (!$urow) {
                    sendMessage($chat_id, "❌ کاربر با این user_id پیدا نشد.\n\nبرای لغو: 🔙 بازگشت", adminDiscountMenuKeyboard());
                    return;
                }

                $codes = listDiscountCodesAll();
                setState($chat_id, 'admin_disc_user_select_code', ['user_id' => $uid]);
                sendMessage($chat_id, "کدام کد را می‌خواهید برای این کاربر اختصاصی کنید؟", adminDiscountCodesKeyboard($codes));
                return;
            }

            // ---- اختصاصی: انتخاب کد و اعمال ----
            if ($state === 'admin_disc_user_select_code') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $row = getDiscountCodeRow((string)$text);
                if (!$row) {
                    sendMessage($chat_id, "❌ کد پیدا نشد. از لیست انتخاب کنید.", adminDiscountMenuKeyboard());
                    return;
                }

                $uid = (int)($data['user_id'] ?? 0);
                $pdo = db();
                $pdo->prepare("UPDATE discount_codes SET user_id=? WHERE id=?")->execute([$uid, (int)$row['id']]);

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ کد اختصاصی شد.\nکد: <code>" . htmlspecialchars((string)$row['code']) . "</code>\nuser_id: <code>{$uid}</code>", adminDiscountMenuKeyboard());
                return;
            }

            // ---- همگانی: انتخاب کد و اعمال ----
            if ($state === 'admin_disc_global_select_code') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                $row = getDiscountCodeRow((string)$text);
                if (!$row) {
                    sendMessage($chat_id, "❌ کد پیدا نشد. از لیست انتخاب کنید.", adminDiscountMenuKeyboard());
                    return;
                }

                $pdo = db();
                $pdo->prepare("UPDATE discount_codes SET user_id=NULL WHERE id=?")->execute([(int)$row['id']]);

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ کد همگانی شد.\nکد: <code>" . htmlspecialchars((string)$row['code']) . "</code>", adminDiscountMenuKeyboard());
                return;
            }

            // ---- حذف: انتخاب کد ----
            if ($state === 'admin_disc_delete_select_code') {
                if ($text === 'بازگشت') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                if ($text === '🗑 حذف همه') {
                    setState($chat_id, 'admin_disc_delete_all_confirm');
                    $kb = [
                        'keyboard' => [
                            [['text' => '✅ بله حذف همه'], ['text' => '❌ خیر']],
                            [['text' => '🔙 بازگشت']],
                        ],
                        'resize_keyboard' => true
                    ];
                    sendMessage($chat_id, "⚠️ آیا مطمئن هستید همه کدهای تخفیف حذف شوند؟

این عملیات قابل بازگشت نیست.", $kb);
                    return;
                }


                $row = getDiscountCodeRow((string)$text);
                if (!$row) {
                    sendMessage($chat_id, "❌ کد پیدا نشد. از لیست انتخاب کنید.", adminDiscountMenuKeyboard());
                    return;
                }

                setState($chat_id, 'admin_disc_delete_confirm', ['code_id' => (int)$row['id'], 'code' => (string)$row['code']]);
                $kb = [
                    'keyboard' => [
                        [['text' => '✅ بله حذف شود'], ['text' => '❌ خیر']],
                        [['text' => '🔙 بازگشت']],
                    ],
                    'resize_keyboard' => true
                ];
                sendMessage($chat_id, "آیا مطمئن هستید این کد حذف شود؟\n\n<code>" . htmlspecialchars((string)$row['code']) . "</code>", $kb);
                return;
            }


            // ---- حذف همه: تایید ----
            if ($state === 'admin_disc_delete_all_confirm') {
                if ($text === 'بازگشت' || $text === '❌ خیر') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                if ($text !== '✅ بله حذف همه') {
                    sendMessage($chat_id, "لطفاً از دکمه‌ها انتخاب کنید.", [
                        'keyboard' => [
                            [['text' => '✅ بله حذف همه'], ['text' => '❌ خیر']],
                            [['text' => '🔙 بازگشت']],
                        ],
                        'resize_keyboard' => true
                    ]);
                    return;
                }

                $pdo = db();
                $pdo->query("DELETE FROM discount_codes");

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ همه کدهای تخفیف حذف شدند.", adminDiscountMenuKeyboard());
                return;
            }

            // ---- حذف: تایید ----
            if ($state === 'admin_disc_delete_confirm') {
                if ($text === 'بازگشت' || $text === '❌ خیر') {
                    clearState($chat_id);
                    setState($chat_id, 'admin_discount_menu');
                    sendMessage($chat_id, "🎟 مدیریت کد تخفیف", adminDiscountMenuKeyboard());
                    return;
                }

                if ($text !== '✅ بله حذف شود') {
                    sendMessage($chat_id, "لطفاً از دکمه‌ها انتخاب کنید.", [
                        'keyboard' => [
                            [['text' => '✅ بله حذف شود'], ['text' => '❌ خیر']],
                            [['text' => '🔙 بازگشت']],
                        ],
                        'resize_keyboard' => true
                    ]);
                    return;
                }

                $codeId = (int)($data['code_id'] ?? 0);
                $pdo = db();
                $pdo->prepare("DELETE FROM discount_codes WHERE id=?")->execute([$codeId]);

                clearState($chat_id);
                setState($chat_id, 'admin_discount_menu');
                sendMessage($chat_id, "✅ حذف شد.", adminDiscountMenuKeyboard());
                return;
            }

            // =========================
            // کانفیگ رایگان: دریافت لینک از ادمین
            // =========================
            if ($state === 'admin_freecfg_wait_link') {
                // اگر ادمین به جای ارسال لینک، یکی از گزینه‌های منو را زد، state را پاک کن و ادامه بده
                $adminMenuTexts = [
                    'سفارشات جدید',
                    'درخواست‌های تمدید',
                    'تیکت‌ها',
                    'ارسال دستی کانفیگ',
                    'ارسال پیام',
                    'آمار',
                    'مدیریت کاربران',
                    'کانفیگ رایگان',
                    'اسپانسر',
                ];
                if (in_array($text, $adminMenuTexts, true)) {
                    clearState($chat_id);
                    // fallthrough به منوهای اصلی
                } else {
                    $link = trim((string)$text);
                    if (mb_strlen($link) < 8) {
                        sendMessage($chat_id, "❌ لینک معتبر نیست. لطفاً لینک ساب رایگان را دوباره ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminMenuKeyboard());
                        return;
                    }

                    $ok = setBotSetting('free_sub_link', $link);
                    if (!$ok) {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ ذخیره‌سازی تنظیمات ناموفق بود.\n\n⚠️ لطفاً ابتدا جدول <b>settings</b> را در دیتابیس ایجاد کنید (SQL آن را در انتهای پیام راهنما قرار داده‌ام).", adminMenuKeyboard());
                        return;
                    }

                    clearState($chat_id);
                    $p = adminFreeConfigPanelPayload();
                    sendMessage($chat_id, "✅ لینک ساب رایگان ذخیره شد.\n\n" . $p['text'], $p['kb']);
                    return;
                }
            }

                                    // =========================
            // 💳 تنظیم شماره کارت (مرحله 1: شماره کارت)
            // =========================
            if ($state === 'admin_card_wait_number') {
                $raw = (string)$text;
                $num = preg_replace('/[^0-9]/', '', $raw);
                if (strlen($num) !== 16) {
                    sendMessage($chat_id, "❌ شماره کارت نامعتبر است.\n\n✅ لطفاً شماره کارت را 16 رقمی ارسال کنید.\n\nبرای لغو: 🔙 بازگشت", adminMenuKeyboard());
                    return;
                }

                clearState($chat_id);
                setState($chat_id, 'admin_card_wait_holder', ['card_number' => $num]);
                sendMessage($chat_id, "👤 لطفاً <b>نام دارنده کارت</b> را وارد نمایید:", adminMenuKeyboard());
                return;
            }

            // =========================
            // 💳 تنظیم شماره کارت (مرحله 2: نام دارنده)
            // =========================
            if ($state === 'admin_card_wait_holder') {
                $holder = trim((string)$text);
                if (mb_strlen($holder) < 2 || mb_strlen($holder) > 80) {
                    sendMessage($chat_id, "❌ نام دارنده کارت نامعتبر است.\n\nحداقل 2 و حداکثر 80 کاراکتر.\n\nبرای لغو: 🔙 بازگشت", adminMenuKeyboard());
                    return;
                }

                $num = (string)($data['card_number'] ?? '');
                $num = preg_replace('/[^0-9]/', '', $num);
                if (strlen($num) !== 16) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ خطا: شماره کارت پیدا نشد. دوباره از «💳 تنظیم شماره کارت» اقدام کنید.", adminMenuKeyboard());
                    return;
                }

                if (!botSettingsTableExists()) {
                    clearState($chat_id);
                    sendMessage(
                        $chat_id,
                        "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.\n\nابتدا جدول settings را بسازید سپس دوباره تلاش کنید.",
                        adminMenuKeyboard()
                    );
                    return;
                }

                $ok1 = setBotSetting('card_number', $num);
                $ok2 = setBotSetting('card_holder', $holder);

                clearState($chat_id);

                if (!$ok1 || !$ok2) {
                    sendMessage($chat_id, "❌ ذخیره‌سازی اطلاعات کارت ناموفق بود.", adminMenuKeyboard());
                    return;
                }

                sendMessage($chat_id, "✅ ثبت شد.\n\n💳 شماره کارت: <code>{$num}</code>\n👤 به نام: <b>" . htmlspecialchars($holder) . "</b>", adminMenuKeyboard());
                return;
            }

// =========================
            // اسپانسر / جوین اجباری: افزودن کانال (مرحله 1: دریافت لینک/آیدی)
            // =========================
            if ($state === 'admin_sponsor_wait_channel') {
                $adminMenuTexts = [
                    'سفارشات جدید',
                    'درخواست‌های تمدید',
                    'تیکت‌ها',
                    'ارسال دستی کانفیگ',
                    'ارسال پیام',
                    'آمار',
                    'مدیریت کاربران',
                    'کانفیگ رایگان',
                    'اسپانسر',
                    '🗂 مدیریت کانفیگ‌ها',
                    '💳 تنظیم شماره کارت',
                ];

                if (in_array($text, $adminMenuTexts, true)) {
                    clearState($chat_id);
                    // fallthrough به منوهای اصلی
                } else {
                    if (!botSettingsTableExists()) {
                        clearState($chat_id);
                        sendMessage(
                            $chat_id,
                            "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.

ابتدا جدول settings را بسازید سپس دوباره تلاش کنید.",
                            adminMenuKeyboard()
                        );
                        return;
                    }

                    $raw = trim((string)$text);
                    $ch = normalizeChannelIdentifier($raw);
                    if ($ch === '') {
                        sendMessage(
                            $chat_id,
                            "❌ لینک/آیدی کانال معتبر نیست.

✅ فرمت‌های قابل قبول:
• <code>@channel</code>
• <code>https://t.me/channel</code>
• <code>-1001234567890</code>

⚠️ لینک‌های خصوصی مثل <code>t.me/+...</code> قابل چک کردن نیستند.

برای لغو: 🔙 بازگشت",
                            adminMenuKeyboard()
                        );
                        return;
                    }

                    clearState($chat_id);
                    setState($chat_id, 'admin_sponsor_wait_label', ['channel' => $ch]);

                    sendMessage(
                        $chat_id,
                        "✍️ <b>نام نمایشی</b> برای دکمه‌های عضویت را ارسال کنید:

مثال:
• <code>عضویت در کانال اول</code>
• <code>عضویت در کانال دوم</code>

برای لغو: 🔙 بازگشت",
                        adminMenuKeyboard()
                    );
                    return;
                }
            }

            // =========================
            // اسپانسر / جوین اجباری: افزودن کانال (مرحله 2: دریافت نام نمایشی)
            // =========================
            if ($state === 'admin_sponsor_wait_label') {
                $adminMenuTexts = [
                    'سفارشات جدید',
                    'درخواست‌های تمدید',
                    'تیکت‌ها',
                    'ارسال دستی کانفیگ',
                    'ارسال پیام',
                    'آمار',
                    'مدیریت کاربران',
                    'کانفیگ رایگان',
                    'اسپانسر',
                    '🗂 مدیریت کانفیگ‌ها',
                    '💳 تنظیم شماره کارت',
                ];

                if (in_array($text, $adminMenuTexts, true)) {
                    clearState($chat_id);
                    // fallthrough
                } else {
                    if (!botSettingsTableExists()) {
                        clearState($chat_id);
                        sendMessage(
                            $chat_id,
                            "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.

ابتدا جدول settings را بسازید سپس دوباره تلاش کنید.",
                            adminMenuKeyboard()
                        );
                        return;
                    }

                    $ch = (string)($data['channel'] ?? '');
                    $ch = normalizeChannelIdentifier($ch);
                    if ($ch === '') {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ خطا: کانال پیدا نشد. دوباره از بخش 📣 اسپانسر اقدام کنید.", adminMenuKeyboard());
                        return;
                    }

                    $label = trim((string)$text);
                    if (mb_strlen($label) < 2 || mb_strlen($label) > 50) {
                        sendMessage($chat_id, "❌ نام نمایشی نامعتبر است.

حداقل 2 و حداکثر 50 کاراکتر.

برای لغو: 🔙 بازگشت", adminMenuKeyboard());
                        return;
                    }

                    $items = getJoinRequiredChannelsItems();

                    $found = false;
                    foreach ($items as &$it) {
                        if (!is_array($it)) continue;
                        if ((string)($it['channel'] ?? '') === $ch) {
                            $it['button_text'] = $label;
                            $it['url'] = channelToUrl($ch) ?: (string)($it['url'] ?? '');
                            $found = true;
                            break;
                        }
                    }
                    unset($it);

                    if (!$found) {
                        $items[] = [
                            'channel' => $ch,
                            'url' => channelToUrl($ch) ?: '',
                            'button_text' => $label,
                        ];
                    }

                    $ok = setJoinRequiredChannelsItems($items);
                    if (!$ok) {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ ذخیره‌سازی تنظیمات ناموفق بود.", adminMenuKeyboard());
                        return;
                    }

                    clearState($chat_id);
                    $p = adminSponsorPanelPayload();
                    sendMessage($chat_id, "✅ ثبت شد.

" . $p['text'], $p['kb']);
                    return;
                }
            }

            // رد کردن سفارش/تمدید (فیش فیک) با نوشتن علت توسط ادمین
            if ($state === 'admin_reject_reason') {
                $kind = (string)($data['kind'] ?? ''); // order | renewal
                $rid = (int)($data['id'] ?? 0);
                $reason = trim((string)$text);

                if ($rid < 1) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ شناسه نامعتبر است.", adminMenuKeyboard());
                    return;
                }

                if (mb_strlen($reason) < 2) {
                    sendMessage($chat_id, "❌ لطفاً علت رد شدن را بنویسید (حداقل 2 کاراکتر).\n\nبرای لغو: 🔙 بازگشت", adminMenuKeyboard());
                    return;
                }
                if (mb_strlen($reason) > 700) {
                    sendMessage($chat_id, "❌ متن علت خیلی طولانی است. لطفاً کوتاه‌تر بنویسید (حداکثر 700 کاراکتر).", adminMenuKeyboard());
                    return;
                }

                $pdo = db();

                if ($kind === 'order') {
                    $q = $pdo->prepare("SELECT o.*, u.chat_id AS u_chat_id, u.username, u.first_name, u.last_name FROM orders o LEFT JOIN users u ON u.id=o.user_id WHERE o.id=? LIMIT 1");
                    $q->execute([$rid]);
                    $o = $q->fetch();

                    if (!$o) {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ سفارش یافت نشد.", adminMenuKeyboard());
                        return;
                    }
                    if (($o['status'] ?? '') !== 'pending') {
                        clearState($chat_id);
                        sendMessage($chat_id, "ℹ️ این سفارش قبلاً بررسی شده است (وضعیت: {$o['status']}).", adminMenuKeyboard());
                        return;
                    }

                    $pdo->prepare("UPDATE orders SET status='rejected', reject_reason=? WHERE id=?")
                        ->execute([$reason, $rid]);

                    // اگر پرداخت با کیف پول بوده، مبلغ را برگردان
                    $refundNote = '';
                    if (($o['payment_method'] ?? '') === 'wallet') {
                        $amt = (int)($o['final_price_toman'] ?? $o['price_toman'] ?? 0);
                        if ($amt > 0) {
                            $ref = walletRefund((int)$o['user_id'], $amt, $rid, null, ['reason' => 'order_rejected']);
                            if (!empty($ref['ok'])) {
                                $refundNote = "\n\n💰 مبلغ <b>" . formatToman($amt) . " تومان</b> به کیف پول شما برگشت داده شد.\nموجودی جدید: <b>" . formatToman((int)($ref['balance'] ?? 0)) . " تومان</b>";
                            } else {
                                $refundNote = "\n\n⚠️ بازگشت مبلغ به کیف پول ناموفق بود. لطفاً به پشتیبانی پیام دهید.";
                            }
                        }
                    }

                    $to = (int)($o['u_chat_id'] ?? 0);
                    if ($to > 0) {
                        // برای جلوگیری از ادامه روندهای قبلی کاربر
                        clearState($to);

                        $msg = "⛔️ فیش پرداخت شما نامعتبر/فیک تشخیص داده شد و درخواست خرید شما رد شد.\n\n";
                        $msg .= "شناسه درخواست: <b>#{$rid}</b>\n";
                        $msg .= "نام سرویس: <b>" . htmlspecialchars((string)$o['config_name']) . "</b>\n\n";
                        $msg .= "علت رد شدن:\n<b>" . htmlspecialchars($reason) . "</b>\n\n";
                        $msg .= "در صورت تمایل می‌توانید دوباره از منوی «خرید سرویس» اقدام کنید.";
                        if (!empty($refundNote)) $msg .= $refundNote;
                        sendMessage($to, $msg, userMenuKeyboard());
                    }

                    // ✅ تغییر وضعیت سفارش در پیام ادمین و حذف دکمه‌ها
                    $srcMid = (int)($data['src_mid'] ?? 0);
                    if ($srcMid > 0) {
                        $baseTxt = (string)($data['src_text'] ?? '');
                        if ($baseTxt === '') $baseTxt = "🧩 سفارش خرید #{$rid}";
                        $statusBlock = "

⛔️ <b>وضعیت:</b> رد شد
<b>علت:</b> " . htmlspecialchars($reason);
                        $newTxt = appendStatusToMessageText($baseTxt, $statusBlock);
                        editMessageReplyMarkup($chat_id, $srcMid, null);
                        editMessageText($chat_id, $srcMid, $newTxt, null);
                    }
                    
                    clearState($chat_id);
                    sendMessage($chat_id, "✅ سفارش #{$rid} رد شد و به کاربر اطلاع داده شد.", adminMenuKeyboard());
                    return;
                }

                if ($kind === 'renewal') {
                    $q = $pdo->prepare("SELECT r.*, u.chat_id AS u_chat_id, u.username, u.first_name, u.last_name, c.name AS cfg_name FROM renewals r LEFT JOIN users u ON u.id=r.user_id LEFT JOIN configs c ON c.id=r.config_id WHERE r.id=? LIMIT 1");
                    $q->execute([$rid]);
                    $r = $q->fetch();

                    if (!$r) {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ درخواست تمدید یافت نشد.", adminMenuKeyboard());
                        return;
                    }
                    if (($r['status'] ?? '') !== 'pending') {
                        clearState($chat_id);
                        sendMessage($chat_id, "ℹ️ این درخواست قبلاً بررسی شده است (وضعیت: {$r['status']}).", adminMenuKeyboard());
                        return;
                    }

                    $pdo->prepare("UPDATE renewals SET status='rejected', reject_reason=? WHERE id=?")
                        ->execute([$reason, $rid]);

                    // اگر پرداخت با کیف پول بوده، مبلغ را برگردان
                    $refundNote = '';
                    if (($r['payment_method'] ?? '') === 'wallet') {
                        $amt = (int)($r['final_price_toman'] ?? $r['price_toman'] ?? 0);
                        if ($amt > 0) {
                            $ref = walletRefund((int)$r['user_id'], $amt, null, $rid, ['reason' => 'renewal_rejected']);
                            if (!empty($ref['ok'])) {
                                $refundNote = "\n\n💰 مبلغ <b>" . formatToman($amt) . " تومان</b> به کیف پول شما برگشت داده شد.\nموجودی جدید: <b>" . formatToman((int)($ref['balance'] ?? 0)) . " تومان</b>";
                            } else {
                                $refundNote = "\n\n⚠️ بازگشت مبلغ به کیف پول ناموفق بود. لطفاً به پشتیبانی پیام دهید.";
                            }
                        }
                    }

                    $to = (int)($r['u_chat_id'] ?? 0);
                    if ($to > 0) {
                        clearState($to);
                        $cfgName = (string)($r['cfg_name'] ?? '—');

                        $msg = "⛔️ فیش تمدید شما نامعتبر/فیک تشخیص داده شد و درخواست تمدید رد شد.\n\n";
                        $msg .= "شناسه درخواست: <b>#{$rid}</b>\n";
                        $msg .= "کانفیگ: <b>" . htmlspecialchars($cfgName) . "</b>\n\n";
                        $msg .= "علت رد شدن:\n<b>" . htmlspecialchars($reason) . "</b>\n\n";
                        $msg .= "در صورت تمایل می‌توانید دوباره از منوی «تمدید کانفیگ» اقدام کنید.";
                        if (!empty($refundNote)) $msg .= $refundNote;
                        sendMessage($to, $msg, userMenuKeyboard());
                    }

                    // ✅ تغییر وضعیت درخواست تمدید در پیام ادمین و حذف دکمه‌ها
                    $srcMid = (int)($data['src_mid'] ?? 0);
                    if ($srcMid > 0) {
                        $baseTxt = (string)($data['src_text'] ?? '');
                        if ($baseTxt === '') $baseTxt = "🔁 درخواست تمدید #{$rid}";
                        $statusBlock = "

⛔️ <b>وضعیت:</b> رد شد
<b>علت:</b> " . htmlspecialchars($reason);
                        $newTxt = appendStatusToMessageText($baseTxt, $statusBlock);
                        editMessageReplyMarkup($chat_id, $srcMid, null);
                        editMessageText($chat_id, $srcMid, $newTxt, null);
                    }
                    
                    clearState($chat_id);
                    sendMessage($chat_id, "✅ درخواست تمدید #{$rid} رد شد و به کاربر اطلاع داده شد.", adminMenuKeyboard());
                    return;
                }



                if ($kind === 'topup') {
                    $q = $pdo->prepare("SELECT t.*, u.chat_id AS u_chat_id, u.username, u.first_name, u.last_name FROM wallet_topups t LEFT JOIN users u ON u.id=t.user_id WHERE t.id=? LIMIT 1");
                    $q->execute([$rid]);
                    $top = $q->fetch();

                    if (!$top) {
                        clearState($chat_id);
                        sendMessage($chat_id, "❌ درخواست شارژ یافت نشد.", adminMenuKeyboard());
                        return;
                    }
                    if (($top['status'] ?? '') !== 'pending') {
                        clearState($chat_id);
                        sendMessage($chat_id, "ℹ️ این درخواست قبلاً بررسی شده است (وضعیت: {$top['status']}).", adminMenuKeyboard());
                        return;
                    }

                    $now2 = time();
                    $pdo->prepare("UPDATE wallet_topups SET status='rejected', reject_reason=?, rejected_at=? WHERE id=?")
                        ->execute([$reason, $now2, $rid]);

                    $to = (int)($top['u_chat_id'] ?? 0);
                    if ($to > 0) {
                        clearState($to);
                        $msg = "⛔️ درخواست شارژ کیف پول شما رد شد.\n\n";
                        $msg .= "شناسه درخواست: <b>#{$rid}</b>\n";
                        $msg .= "مبلغ: <b>" . formatToman((int)($top['amount_toman'] ?? 0)) . " تومان</b>\n\n";
                        $msg .= "علت رد شدن:\n<b>" . htmlspecialchars($reason) . "</b>\n\n";
                        $msg .= "در صورت تمایل می‌توانید دوباره از منوی «کیف پول» اقدام کنید.";
                        sendMessage($to, $msg, userMenuKeyboard());
                    }

                    clearState($chat_id);
                    sendMessage($chat_id, "✅ درخواست شارژ #{$rid} رد شد و به کاربر اطلاع داده شد.", adminMenuKeyboard());
                    return;
                }

                clearState($chat_id);
                sendMessage($chat_id, "❌ نوع درخواست نامعتبر است.", adminMenuKeyboard());
                return;
            }

            // ارسال لینک کانفیگ برای سفارش
            if ($state === 'admin_wait_cfg_link') {
                $order_id = (int)($data['order_id'] ?? 0);
                $link = trim($text);
                if (mb_strlen($link) < 8) {
                    sendMessage($chat_id, "❌ لینک معتبر نیست. دوباره ارسال کنید یا 'بازگشت'.", adminMenuKeyboard());
                    return;
                }


                // ✅ اطمینان از وجود تگ #دژنت در انتهای لینک
                $link = ensureLinkHasDNetTag($link);
                $pdo = db();
                $order = $pdo->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
                $order->execute([$order_id]);
                $o = $order->fetch();
                if (!$o) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ سفارش یافت نشد.", adminMenuKeyboard());
                    return;
                }

                if ($o['status'] !== 'pending') {
                    clearState($chat_id);
                    sendMessage($chat_id, "ℹ️ این سفارش قبلاً بررسی شده است (وضعیت: {$o['status']}).", adminMenuKeyboard());
                    return;
                }

                $usr = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
                $usr->execute([(int)$o['user_id']]);
                $userRow = $usr->fetch();
                if (!$userRow) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ کاربر سفارش یافت نشد.", adminMenuKeyboard());
                    return;
                }

                $cfgId = addConfigForUser(
                    (int)$o['user_id'],
                    (string)$o['config_name'],
                    MAIN_PROTOCOL,
                    $o['plan_id'] !== null ? (int)$o['plan_id'] : null,
                    $link,
                    (int)$o['data_gb'],
                    (int)$o['duration_days'],
                    (int)$o['price_toman']
                );

                markConfigDelivered((int)$cfgId);

                $pdo->prepare("UPDATE orders SET status='completed' WHERE id=?")->execute([$order_id]);

                // پرداخت پورسانت زیرمجموعه‌گیری (در صورت وجود)
                $comm = processReferralCommissionForOrder($order_id);
                if (!empty($comm['ok']) && empty($comm['skipped']) && !empty($comm['referrer_id'])) {
                    // پیام به معرف
                    $refUser = $pdo->prepare("SELECT chat_id FROM users WHERE id=? LIMIT 1");
                    $refUser->execute([(int)$comm['referrer_id']]);
                    $refChat = (int)$refUser->fetchColumn();
                    if ($refChat > 0) {
                        $msgRef = "💸 پورسانت خرید زیرمجموعه\n\n";
                        $msgRef .= "مبلغ <b>" . formatToman((int)$comm['commission']) . " تومان</b> به کیف پول شما اضافه شد ✅\n";
                        $msgRef .= "موجودی جدید: <b>" . formatToman((int)$comm['balance']) . " تومان</b>";
                        sendMessage($refChat, $msgRef, userMenuKeyboard());
                    }
                }


                // استخراج گروه/پلن (برای سفارش‌های قدیمی ممکن است در جدول orders ذخیره نشده باشد)
                $gk = (string)($o['plan_group_key'] ?? '');
                $pt = (string)($o['plan_title'] ?? '');
                if (($gk === '' || $pt === '') && $o['plan_id'] !== null) {
                    $pRow = getPlan((int)$o['plan_id']);
                    if ($gk === '' && !empty($pRow['group_key'])) $gk = (string)$pRow['group_key'];
                    if ($pt === '' && !empty($pRow['title'])) $pt = (string)$pRow['title'];
                }
                if ($gk === '') $gk = 'bulk';
                if ($pt === '') $pt = '—';

                $txt = "🎉 سرویس شما آماده شد\n\n";
                $txt .= "گروه: <b>" . htmlspecialchars(planGroupTitle($gk)) . "</b>\n";
                $txt .= "پلن: <b>" . htmlspecialchars($pt) . "</b>\n";
                $txt .= "نام سرویس: <b>" . htmlspecialchars($o['config_name']) . "</b>\n";
                $txt .= "پروتکل: <b>" . MAIN_PROTOCOL . "</b>\n";
                $txt .= "حجم: <b>" . htmlspecialchars(formatPlanDataLabel((int)$o['data_gb'])) . "</b>\n";
                $txt .= "مدت: <b>" . (int)$o['duration_days'] . " روز</b>\n\n";
                $txt .= "لینک ساب:\n<code>" . htmlspecialchars($link) . "</code>";

                sendMessage((int)$userRow['chat_id'], $txt, userMenuKeyboard());

                // ✅ تغییر وضعیت سفارش در پیام ادمین و حذف دکمه‌ها
                $srcMid = (int)($data['src_mid'] ?? 0);
                if ($srcMid > 0) {
                    $baseTxt = (string)($data['src_text'] ?? '');
                    if ($baseTxt === '') $baseTxt = "🧩 سفارش خرید #{$order_id}";
                    $statusBlock = "

✅ <b>وضعیت:</b> انجام شد";
                    $newTxt = appendStatusToMessageText($baseTxt, $statusBlock);
                    editMessageReplyMarkup($chat_id, $srcMid, null);
                    editMessageText($chat_id, $srcMid, $newTxt, null);
                }

                clearState($chat_id);
                sendMessage($chat_id, "✅ لینک ذخیره شد و برای کاربر ارسال شد.", adminMenuKeyboard());
                return;
            }

            // پاسخ به تیکت
            if ($state === 'admin_reply_ticket') {
                $ticket_id = (int)($data['ticket_id'] ?? 0);
                $reply = trim($text);
                if ($reply === '') {
                    sendMessage($chat_id, "❌ لطفاً متن پاسخ را ارسال کنید.");
                    return;
                }

                $pdo = db();
                $tq = $pdo->prepare("SELECT * FROM tickets WHERE id=? LIMIT 1");
                $tq->execute([$ticket_id]);
                $ticket = $tq->fetch();
                if (!$ticket) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ تیکت یافت نشد.", adminMenuKeyboard());
                    return;
                }

                $uQ = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
                $uQ->execute([(int)$ticket['user_id']]);
                $userRow = $uQ->fetch();
                if (!$userRow) {
                    clearState($chat_id);
                    sendMessage($chat_id, "❌ کاربر تیکت یافت نشد.", adminMenuKeyboard());
                    return;
                }

                $now = time();
                $pdo->prepare("UPDATE tickets SET status='answered', admin_reply_text=?, answered_at=? WHERE id=?")
                    ->execute([$reply, $now, $ticket_id]);

                sendMessage((int)$userRow['chat_id'], "🟢 پاسخ پشتیبانی:

" . htmlspecialchars($reply), userMenuKeyboard());

                // ✅ آپدیت پیام ادمین (حذف دکمه پاسخ + نمایش وضعیت پاسخ داده شد)
                $srcMid = (int)($data['src_mid'] ?? 0);
                $srcText = (string)($data['src_text'] ?? '');
                if ($srcMid > 0 && strpos($srcText, "🎫 تیکت جدید") === 0) {
                    $statusBlock = "

✅ <b>وضعیت:</b> پاسخ داده شد";
                    $newTxt = appendStatusToMessageText($srcText, $statusBlock);
                    editMessageReplyMarkup($chat_id, $srcMid, null);
                    editMessageText($chat_id, $srcMid, $newTxt, null);
                }

                clearState($chat_id);
                sendMessage($chat_id, "✅ پاسخ برای کاربر ارسال شد.", adminMenuKeyboard());
                return;
            }

            // ارسال دستی کانفیگ (گام 1)
            if ($state === 'admin_manual_cfg_chatid') {
                $cid = trim($text);
                if (!preg_match('/^\d{6,20}$/', $cid)) {
                    sendMessage($chat_id, "❌ آیدی عددی نامعتبر است. مثال: 123456789\n\nیا 'بازگشت'.");
                    return;
                }
                $uid = ensureUserByChatId((int)$cid);
                setState($chat_id, 'admin_manual_cfg_name', ['chat_id' => (int)$cid, 'user_id' => $uid]);
                sendMessage($chat_id, "✅ کاربر ثبت شد.\n\nنام کانفیگ را ارسال کنید:", adminMenuKeyboard());
                return;
            }
            if ($state === 'admin_manual_cfg_name') {
                $name = trim($text);
                if (mb_strlen($name) < 2 || mb_strlen($name) > 60) {
                    sendMessage($chat_id, "❌ نام نامعتبر است. (2 تا 60 کاراکتر)");
                    return;
                }
                $data['name'] = $name;
                setState($chat_id, 'admin_manual_cfg_volume', $data);
                sendMessage($chat_id, "حجم را ارسال کنید (10 تا 1000 گیگ):", adminMenuKeyboard());
                return;
            }
            if ($state === 'admin_manual_cfg_volume') {
                $v = (int)trim($text);
                if ($v < 10 || $v > 1000) {
                    sendMessage($chat_id, "❌ حجم نامعتبر است. (10 تا 1000)");
                    return;
                }
                $data['data_gb'] = $v;
                setState($chat_id, 'admin_manual_cfg_duration', $data);
                sendMessage($chat_id, "مدت را ارسال کنید (15 تا 60 روز):", adminMenuKeyboard());
                return;
            }
            if ($state === 'admin_manual_cfg_duration') {
                $d = (int)trim($text);
                if ($d < 15 || $d > 60) {
                    sendMessage($chat_id, "❌ مدت نامعتبر است. (15 تا 60)");
                    return;
                }
                $data['duration_days'] = $d;
                setState($chat_id, 'admin_manual_cfg_price', $data);
                sendMessage($chat_id, "قیمت را ارسال کنید (تومان). مثال: 65000", adminMenuKeyboard());
                return;
            }
            if ($state === 'admin_manual_cfg_price') {
                $p = (int)preg_replace('/[^0-9]/', '', $text);
                if ($p < 0) $p = 0;
                $data['price_toman'] = $p;
                setState($chat_id, 'admin_manual_cfg_link', $data);
                sendMessage($chat_id, "لینک ساب را ارسال کنید:", adminMenuKeyboard());
                return;
            }
            if ($state === 'admin_manual_cfg_link') {
                $link = trim($text);
                if (mb_strlen($link) < 8) {
                    sendMessage($chat_id, "❌ لینک معتبر نیست. دوباره ارسال کنید.");
                    return;
                }


                // ✅ اطمینان از وجود تگ #دژنت در انتهای لینک
                $link = ensureLinkHasDNetTag($link);
                $pdo = db();
                $user_id = (int)($data['user_id'] ?? 0);
                $to_chat = (int)($data['chat_id'] ?? 0);

                $cfgId = addConfigForUser(
                    $user_id,
                    (string)$data['name'],
                    MAIN_PROTOCOL,
                    null,
                    $link,
                    (int)$data['data_gb'],
                    (int)$data['duration_days'],
                    (int)$data['price_toman']
                );

                markConfigDelivered((int)$cfgId);

                $msg = "🎉 سرویس برای شما ارسال شد\n\n";
                $msg .= "نام: <b>" . htmlspecialchars((string)$data['name']) . "</b>\n";
                $msg .= "پروتکل: <b>" . MAIN_PROTOCOL . "</b>\n";
                $msg .= "حجم: <b>" . htmlspecialchars(formatPlanDataLabel((int)$data['data_gb'])) . "</b>\n";
                $msg .= "مدت: <b>" . (int)$data['duration_days'] . " روز</b>\n\n";
                $msg .= "لینک ساب:\n<code>" . htmlspecialchars($link) . "</code>";

                $send = sendMessage($to_chat, $msg, userMenuKeyboard());
                if (!$send || empty($send['ok'])) {
                    // اگر ارسال نشد، احتمالاً کاربر ربات را استارت نکرده
                    sendMessage($chat_id, "⚠️ سرویس در دیتابیس ذخیره شد، اما ارسال به کاربر ناموفق بود (ممکن است کاربر هنوز /start نکرده باشد).", adminMenuKeyboard());
                } else {
                    sendMessage($chat_id, "✅ سرویس ذخیره و برای کاربر ارسال شد.", adminMenuKeyboard());
                }

                clearState($chat_id);
                return;
            }

            // ارسال پیام همگانی
            if ($state === 'admin_broadcast_wait') {
                $pdo = db();
                $now = time();

                $stmt = $pdo->prepare(
                    "INSERT INTO broadcasts (admin_chat_id, source_chat_id, source_message_id, status, created_at) VALUES (?,?,?,'pending',?)"
                );
                $stmt->execute([ADMIN_ID, ADMIN_ID, (int)$m['message_id'], $now]);
                $bid = (int)$pdo->lastInsertId();

                clearState($chat_id);
                sendMessage($chat_id, "✅ پیام همگانی ثبت شد.\n\n🕒 ارسال توسط <b>cron.php</b> انجام می‌شود. پس از اتمام، گزارش نهایی ارسال خواهد شد.\nشناسه: #{$bid}", adminMenuKeyboard());
                return;
            }
        }
    }

    // --- منوهای اصلی (بدون State) ---

    // ادمین
    if (isAdmin($chat_id)) {
        if ($text === 'سفارشات جدید' || $text === '🧾 سفارشات جدید') {
            $pdo = db();
            $rows = $pdo->query("SELECT o.*, u.chat_id, u.username, u.first_name, u.last_name
                FROM orders o
                LEFT JOIN users u ON u.id=o.user_id
                WHERE o.status='pending'
                ORDER BY o.id DESC LIMIT 20")->fetchAll();

            if (!$rows) {
                sendMessage($chat_id, "— سفارشی برای بررسی وجود ندارد —", adminMenuKeyboard());
                return;
            }

            $textOut = "📬 سفارشات جدید (20 مورد آخر):\n\n";
            $ik = [];
            foreach ($rows as $r) {
                $showPrice = (int)($r['final_price_toman'] ?? 0);
                if ($showPrice <= 0) $showPrice = (int)$r['price_toman'];
                $pm = (string)($r['payment_method'] ?? 'card');
                $pmLabel = ($pm === 'wallet') ? 'کیف پول' : 'کارت‌به‌کارت';
                $textOut .= "• #{$r['id']} | {$r['config_name']} | {$r['data_gb']}GB | {$r['duration_days']} روز | " . formatToman($showPrice) . " ت | {$pmLabel}\n";
                $textOut .= formatUserLine($r) . "\n\n";
                $ik[] = [
                    ['text' => "ارسال کانفیگ #{$r['id']}", 'callback_data' => 'admin:order:sendcfg:' . $r['id']],
                    ['text' => "رد فیش #{$r['id']}", 'callback_data' => 'admin:order:reject:' . $r['id']],
                ];
            }
            sendMessage($chat_id, $textOut, ['inline_keyboard' => $ik]);
            return;
        }

        if ($text === 'درخواست‌های تمدید' || $text === '♻️ درخواست‌های تمدید') {
            $pdo = db();
            $rows = $pdo->query("SELECT r.*, c.name AS cfg_name, c.link AS cfg_link, u.chat_id, u.username, u.first_name, u.last_name
                FROM renewals r
                LEFT JOIN configs c ON c.id=r.config_id
                LEFT JOIN users u ON u.id=r.user_id
                WHERE r.status='pending'
                ORDER BY r.id DESC LIMIT 20")->fetchAll();

            if (!$rows) {
                sendMessage($chat_id, "— تمدیدی برای بررسی وجود ندارد —", adminMenuKeyboard());
                return;
            }

            $textOut = "🔁 درخواست‌های تمدید (20 مورد آخر):\n\n";
            $ik = [];
            foreach ($rows as $r) {
                $showPrice = (int)($r['final_price_toman'] ?? 0);
                if ($showPrice <= 0) $showPrice = (int)($r['price_toman'] ?? 0);
                $pm = (string)($r['payment_method'] ?? 'card');
                $pmLabel = ($pm === 'wallet') ? 'کیف پول' : 'کارت‌به‌کارت';
                $pricePart = ($showPrice > 0) ? (' | ' . formatToman($showPrice) . ' ت') : '';
                $textOut .= "• #{$r['id']} | {$r['cfg_name']}{$pricePart} | {$pmLabel}\n";
                $textOut .= formatUserLine($r) . "\n\n";
                $ik[] = [
                    ['text' => "تأیید تمدید #{$r['id']}", 'callback_data' => 'admin:renew:approve:' . $r['id']],
                    ['text' => "رد فیش #{$r['id']}", 'callback_data' => 'admin:renew:reject:' . $r['id']],
                ];
            }
            sendMessage($chat_id, $textOut, ['inline_keyboard' => $ik]);
            return;
        }

        if ($text === 'تیکت‌ها' || $text === '🎫 تیکت‌ها') {
            $pdo = db();
            $rows = $pdo->query("SELECT t.*, u.chat_id, u.username, u.first_name, u.last_name
                FROM tickets t
                LEFT JOIN users u ON u.id=t.user_id
                WHERE t.status='open'
                ORDER BY t.id DESC LIMIT 20")->fetchAll();

            if (!$rows) {
                sendMessage($chat_id, "— تیکت بازی وجود ندارد —", adminMenuKeyboard());
                return;
            }

            $textOut = "🎫 تیکت‌های باز (20 مورد آخر):\n\n";
            $ik = [];
            foreach ($rows as $t) {
                $preview = mb_strimwidth((string)$t['message_text'], 0, 50, '…', 'UTF-8');
                $textOut .= "• #{$t['id']} | {$preview}\n";
                $textOut .= formatUserLine($t) . "\n\n";
                $ik[] = [
                    ['text' => "پاسخ به #{$t['id']}", 'callback_data' => 'admin:ticket:reply:' . $t['id']]
                ];
            }
            sendMessage($chat_id, $textOut, ['inline_keyboard' => $ik]);
            return;
        }

        if ($text === 'ارسال دستی کانفیگ' || $text === '🧩 ارسال دستی کانفیگ') {
            clearState($chat_id);
            setState($chat_id, 'admin_manual_cfg_chatid');
            sendMessage($chat_id, "🧩 ارسال دستی کانفیگ\n\nلطفاً آیدی عددی کاربر (chat_id) را ارسال کنید:", adminMenuKeyboard());
            return;
        }

        if ($text === 'مدیریت کانفیگ ها' || $text === 'مدیریت کانفیگ‌ها' || $text === '🗂 مدیریت کانفیگ‌ها' || $text === '🗂 مدیریت کانفیگ ها') {
            clearState($chat_id);

            if (!planGroupsTableExists()) {
                sendMessage(
                    $chat_id,
                    "⚠️ برای استفاده از «🗂 مدیریت کانفیگ‌ها»، لازم است جدول‌های جدید دیتابیس را بسازید.\n\n✅ لطفاً SQL آپدیت دیتابیس را اجرا کنید.",
                    adminMenuKeyboard()
                );
                return;
            }

            setState($chat_id, 'admin_cfg_manage_menu');
            sendMessage(
                $chat_id,
                "🗂 <b>مدیریت کانفیگ‌ها</b>\n\nیکی از گزینه‌های زیر را انتخاب کنید:",
                adminConfigManageKeyboard()
            );
            return;
        }

if ($text === '💳 تنظیم شماره کارت' || $text === 'تنظیم شماره کارت') {
            clearState($chat_id);

            if (!botSettingsTableExists()) {
                sendMessage(
                    $chat_id,
                    "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.

لطفاً ابتدا جدول settings را بسازید، سپس دوباره تلاش کنید.",
                    adminMenuKeyboard()
                );
                return;
            }

            setState($chat_id, 'admin_card_wait_number');
            sendMessage($chat_id, "💳 لطفاً <b>شماره کارت</b> را وارد نمایید:", adminMenuKeyboard());
            return;
        }


        // ارسال پیام (زیرمنو: خصوصی/همگانی)
        if (
            $text === 'ارسال پیام' ||
            $text === '✉️ ارسال پیام' ||
            $text === 'ارسال پیام همگانی' ||
            $text === '📢 ارسال پیام همگانی'
        ) {
            clearState($chat_id);
            setState($chat_id, 'admin_message_menu');
            sendMessage(
                $chat_id,
                "✉️ ارسال پیام\n\nیکی از گزینه‌های زیر را انتخاب کنید:",
                adminMessageMenuKeyboard()
            );
            return;
        }

        if ($text === 'مدیریت کاربران' || $text === 'لیست کاربران' || $text === '👥 لیست کاربران') {
            clearState($chat_id);
            setState($chat_id, 'admin_users_manage_menu');
            sendMessage(
                $chat_id,
                "👥 مدیریت کاربران

یکی از گزینه‌های زیر را انتخاب کنید:",
                adminUsersManageMenuKeyboard()
            );
            return;
        }

        if ($text === 'مدیریت کد تخفیف' || $text === '🎟 مدیریت کد تخفیف') {
            clearState($chat_id);

            if (!discountTablesExist()) {
                sendMessage(
                    $chat_id,
                    "⚠️ جدول‌های <b>discount_codes</b> و <b>discount_usages</b> در دیتابیس پیدا نشد.

لطفاً SQL آپدیت دیتابیس کد تخفیف را اجرا کنید.",
                    adminMenuKeyboard()
                );
                return;
            }

            if (!discountAdminColumnsReady()) {
                sendMessage(
                    $chat_id,
                    "⚠️ ساختار دیتابیس کد تخفیف برای پنل مدیریت کامل نیست.

لطفاً SQL آپدیت «ستون‌های starts_at و user_id» را اجرا کنید، سپس دوباره وارد این بخش شوید.",
                    adminMenuKeyboard()
                );
                return;
            }

            setState($chat_id, 'admin_discount_menu');
            sendMessage($chat_id, "🎟 مدیریت کد تخفیف

یکی از گزینه‌های زیر را انتخاب کنید:", adminDiscountMenuKeyboard());
            return;
        }


        if (
            $text === 'شارژ کیف پول' ||
            $text === '💰 شارژ کیف پول' ||
            $text === 'شارژ کیف پول کاربر' ||
            $text === '💰 شارژ کیف پول کاربر'
        ) {
            clearState($chat_id);
            setState($chat_id, 'admin_wallet_topup_menu');
            sendMessage(
                $chat_id,
                "💰 شارژ کیف پول\n\nنوع شارژ را انتخاب کنید:",
                adminWalletTopupMenuKeyboard()
            );
            return;
        }

        // سازگاری با نسخه‌های قبلی (اگر دستی تایپ شد)
        if ($text === 'شارژ همگانی' || $text === '🌐 شارژ همگانی' || $text === '🌍 شارژ همگانی') {
            clearState($chat_id);
            setState($chat_id, 'admin_wallet_bulk_wait_amount');
            sendMessage(
                $chat_id,
                "🌍 شارژ همگانی کیف پول\n\nلطفاً مبلغ شارژ برای <b>همه کاربران</b> را به تومان ارسال کنید (فقط عدد).\n\nبرای لغو: 🔙 بازگشت",
                adminWalletTopupMenuKeyboard()
            );
            return;
        }

        if ($text === 'آمار' || $text === '📊 آمار') {
            $pdo = db();
            $totalUsers = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
            $blocked = (int)$pdo->query("SELECT COUNT(*) FROM users WHERE is_blocked=1")->fetchColumn();
            $ordersPending = (int)$pdo->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetchColumn();
            $renewPending = (int)$pdo->query("SELECT COUNT(*) FROM renewals WHERE status='pending'")->fetchColumn();
            $ticketsOpen = (int)$pdo->query("SELECT COUNT(*) FROM tickets WHERE status='open'")->fetchColumn();
            $configs = (int)$pdo->query("SELECT COUNT(*) FROM configs WHERE active=1")->fetchColumn();

            $msg = "📊 آمار\n\n";
            $msg .= "کاربران: <b>{$totalUsers}</b>\n";
            $msg .= "کاربران بلاک‌شده: <b>{$blocked}</b>\n";
            $msg .= "کانفیگ‌های فعال: <b>{$configs}</b>\n\n";
            $msg .= "سفارشات در انتظار: <b>{$ordersPending}</b>\n";
            $msg .= "تمدیدهای در انتظار: <b>{$renewPending}</b>\n";
            $msg .= "تیکت‌های باز: <b>{$ticketsOpen}</b>";

            sendMessage($chat_id, $msg, adminMenuKeyboard());
            return;
        }

        if ($text === 'کانفیگ رایگان' || $text === '🎁 کانفیگ رایگان') {
            clearState($chat_id);

            if (!botSettingsTableExists()) {
                sendMessage(
                    $chat_id,
                    "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.\n\n" .
                    "لطفاً SQL مربوط به ساخت جدول را اجرا کنید، سپس دوباره وارد این بخش شوید.",
                    adminMenuKeyboard()
                );
                return;
            }

            setState($chat_id, 'admin_freecfg_wait_link');
            $p = adminFreeConfigPanelPayload();
            sendMessage($chat_id, "🔗 لطفاً <b>لینک ساب رایگان</b> را ارسال کنید:\n\n" . $p['text'], $p['kb']);
            return;
        }

        if ($text === 'اسپانسر' || $text === '📣 اسپانسر') {
            clearState($chat_id);

            if (!botSettingsTableExists()) {
                sendMessage(
                    $chat_id,
                    "⚠️ جدول <b>settings</b> در دیتابیس پیدا نشد.

" .
                    "لطفاً ابتدا جدول settings را بسازید، سپس دوباره وارد این بخش شوید.",
                    adminMenuKeyboard()
                );
                return;
            }

            $p = adminSponsorPanelPayload();
            sendMessage($chat_id, $p['text'], $p['kb']);
            return;
        }

        // اگر ادمین چیز دیگری نوشت
        sendMessage($chat_id, "از منوی ادمین یک گزینه را انتخاب کنید یا /start.", adminMenuKeyboard());
        return;
    }

    // کاربر عادی
    if ($text === 'خرید کانفیگ' || $text === '🛒 خرید کانفیگ') {
        // مرحله اول: انتخاب گروه (داینامیک)
        $kb = buildBuyGroupKeyboard();

        sendMessage(
            $chat_id,
            "🛒 خرید سرویس\n\nابتدا <b>گروه</b> را انتخاب کنید:",
            $kb
        );
        return;
    }

    if ($text === 'تمدید کانفیگ' || $text === '🔄 تمدید کانفیگ') {
        $cfgs = listUserConfigs($chat_id);
        if (!$cfgs) {
            sendMessage($chat_id, "📂 📂 📂 📂 هنوز کانفیگی برای شما ثبت نشده است.", userMenuKeyboard());
            return;
        }

        $rows = [];
        foreach ($cfgs as $c) {
            $rows[] = [[
                'text' => "{$c['name']} ({$c['data_gb']}GB)",
                'callback_data' => 'renew:select:' . (int)$c['id'],
            ]];
        }

        sendMessage($chat_id, "کانفیگی که می‌خواهید تمدید کنید را انتخاب کنید:", ['inline_keyboard' => $rows]);
        return;
    }

    if ($text === 'سرویس‌های من' || $text === '📂 سرویس‌های من') {
        showUserServices($chat_id);
        return;
    }

if ($text === 'کانفیگ رایگان' || $text === '🎁 کانفیگ رایگان') {
        if (!freeConfigIsEnabled()) {
            sendMessage($chat_id, "❌ کانفیگ رایگان فعلاً غیرفعال است.", userMenuKeyboard());
            return;
        }

        $link = getFreeSubLink();
        if ($link === '') {
            sendMessage($chat_id, "⚠️ لینک کانفیگ رایگان هنوز توسط ادمین تنظیم نشده است.", userMenuKeyboard());
            return;
        }

        $msg = "🎁 <b>کانفیگ رایگان</b>\n\n";
        $msg .= "لینک ساب:\n<code>" . htmlspecialchars($link) . "</code>";
        sendMessage($chat_id, $msg, userMenuKeyboard());
        recordFreeConfigUsageForChatId($chat_id);
        return;
    }

    if ($text === 'نحوه اتصال' || $text === '📡 نحوه اتصال') {
        sendMessage($chat_id, "📡 راهنمای اتصال در کانال زیر قرار دارد:\n@denet_Connect", userMenuKeyboard());
        return;
    }

    if ($text === 'پشتیبانی' || $text === '🆘 پشتیبانی') {
        clearState($chat_id);
        setState($chat_id, 'ticket_wait_message');
        sendMessage($chat_id, "🆘 پشتیبانی\n\nپیام خود را ارسال کنید:", userMenuKeyboard());
        return;
    }

    if ($text === 'زیرمجموعه گیری' || $text === 'زیرمجموعه‌گیری' || $text === '👥 زیرمجموعه‌گیری') {
        $user = getUserByChatId($chat_id);
        if (!$user) {
            sendMessage($chat_id, "❌ کاربر یافت نشد. /start را بزنید.", userMenuKeyboard());
            return;
        }

        $uid = (int)$user['id'];
        $stats = getReferralStats($uid);

        $msg = "💸 پورسانت خرید:\n";
        $msg .= "•  <b>" . (int)REFERRAL_COMMISSION_PERCENT . " درصد</b> از مبلغ خرید زیرمجموعه به شما تعلق می‌گیره\n\n";
        $msg .= "📊 <b>آمار شما:</b>\n";
        $msg .= "• 👥 زیرمجموعه‌ها: <b>" . (int)$stats['referrals'] . " نفر</b>\n";
        $msg .= "• 🛒 خریدها: <b>" . (int)$stats['purchases'] . " عدد</b>\n";
        $msg .= "• 💵 مجموع خرید: <b>" . formatToman((int)$stats['total_purchase']) . " تومان</b>\n\n";
        $msg .= "📢 دعوت کن، هدیه بگیر، رشد کن!";

        $link = getReferralLinkByUserId($uid);
        $shareUrl = null;
        if ($link) {
            $shareText = "با این لینک وارد ربات شو و خرید کن تا پورسانت بگیرم 👇";
            $shareUrl = "https://t.me/share/url?url=" . urlencode($link) . "&text=" . urlencode($shareText);
        }

        // مرتب‌سازی دکمه‌ها در دو ستون
        $kb = [
            'inline_keyboard' => [
                [
                    $shareUrl ? ['text' => '🔗 اشتراک‌گذاری لینک', 'url' => $shareUrl] : ['text' => '⚠️ لینک دعوت نامشخص', 'callback_data' => 'ref:link:help'],
                    ['text' => '🎁 دریافت هدیه عضویت', 'callback_data' => 'ref:gift'],
                ],
            ]
        ];

        sendMessage($chat_id, $msg, $kb);
        if (!$link) {
            sendMessage($chat_id, "⚠️ برای ساخت لینک دعوت، ربات باید username داشته باشد. اگر مشکل ادامه داشت، یکبار وبهوک را ریست کنید یا در BotFather برای ربات username تنظیم کنید.", userMenuKeyboard());
        } else {
            // همچنین لینک را جداگانه نمایش بده تا کاربر راحت کپی کند
            sendMessage($chat_id, "🔗 لینک اختصاصی شما:\n<code>" . htmlspecialchars($link) . "</code>", userMenuKeyboard());
        }
        return;
    }

    if ($text === 'کیف پول' || $text === '💰 کیف پول') {
        $bal = getWalletBalanceByChatId($chat_id);

        $msg = "💰 <b>کیف پول شما</b>\n\n";
        $msg .= "موجودی: <b>" . formatToman($bal) . " تومان</b>\n\n";
        $msg .= "✅ در خرید و تمدید می‌توانید از موجودی کیف پول استفاده کنید.\n";
        $msg .= "➕ برای شارژ کیف پول، از دکمه زیر استفاده کنید و فیش را ارسال کنید تا ادمین تأیید کند.";

        $kb = [
            'inline_keyboard' => [
                [
                    ['text' => '➕ شارژ کیف پول', 'callback_data' => 'wallet:topup:start'],
                    ['text' => '🔄 بروزرسانی', 'callback_data' => 'wallet:refresh'],
                ],
            ],
        ];

        sendMessage($chat_id, $msg, $kb);
        return;
    }


// پیام نامعتبر
    sendMessage($chat_id, "لطفاً از منو یکی از گزینه‌ها را انتخاب کنید یا /start.", userMenuKeyboard());
}

function handleCallback(array $cb) {
    $data = $cb['data'] ?? '';
    $chat_id = (int)($cb['from']['id'] ?? 0);
    $cb_message = $cb['message'] ?? [];
    $mid = (int)($cb_message['message_id'] ?? 0);
    $qid = (string)($cb['id'] ?? '');

    // ✅ اجبار عضویت (قبل از هر پردازش کال‌بک)
    $messageText = $cb_message['text'] ?? ($cb_message['caption'] ?? '');
    if (!forceJoinCheck($chat_id, [
        'user_id' => $chat_id,
        'callback_query_id' => (string)($cb['id'] ?? ''),
        'message_id' => $mid,
        'message_text' => $messageText,
    ])) {
        return;
    }

    // عضویت تایید شد؛ حالا کال‌بک را جواب بدهیم
    // پاسخ اولیه برای قطع شدن حالت «لودینگ» روی دکمه‌ها
    if ($qid !== '') {
        answerCallback($qid);
    }

    // دکمه‌های نمایشی
    if ($data === 'noop') return;


    // بلاک بودن کاربر (برای کال‌بک‌ها) - ادمین مستثنی است
    if (!isAdmin($chat_id)) {
        $u = getUserByChatId($chat_id);
        if ($u && (int)($u['is_blocked'] ?? 0) === 1) {
            sendMessage($chat_id, "⛔️ دسترسی شما مسدود شده است.", null);
            return;
        }
    }

    // ⛔️ حذف کامل دکمه «پنل ادمین» از نوار پیام (در صورت تنظیم قبلی)
    if (isAdmin($chat_id)) {
        removeCustomChatMenuButtonForChat($chat_id);
    }

    // دکمه «✅ عضو شدم» (نسخه جدید + سازگاری با پیام‌های قدیمی)
    if ($data === 'force_join:check' || $data === 'check_join') {
        ensureBotMenuButton();
        clearState($chat_id);

        if (isAdmin($chat_id)) {
            sendMessage($chat_id, "👑 پنل ادمین\n\nیکی از گزینه‌های زیر را انتخاب کنید:", adminMenuKeyboard());
        } else {
            sendMessage($chat_id, "سلام! خوش آمدید 🌟\n\nیکی از گزینه‌های زیر را انتخاب کنید:", userMenuKeyboard());
        }
        return;
    }

    // --- USER CALLBACKS ---
    if (!isAdmin($chat_id)) {

        // ===== کیف پول: شروع شارژ / بروزرسانی موجودی =====
        if ($data === 'wallet:topup:start') {
            clearState($chat_id);
            setState($chat_id, 'wallet_topup_wait_amount');
            sendMessage($chat_id, "➕ شارژ کیف پول\n\nلطفاً مبلغ موردنظر را به تومان ارسال کنید (فقط عدد).\nمثال: <code>50000</code>\n\nبرای لغو: 🔙 بازگشت");
            return;
        }

        if ($data === 'wallet:refresh') {
            $bal = getWalletBalanceByChatId($chat_id);
            $msg = "💰 <b>کیف پول شما</b>\n\n";
            $msg .= "موجودی: <b>" . formatToman($bal) . " تومان</b>\n\n";
            $msg .= "✅ در خرید و تمدید می‌توانید از موجودی کیف پول استفاده کنید.\n";
            $msg .= "➕ برای شارژ کیف پول، از دکمه زیر استفاده کنید و فیش را ارسال کنید تا ادمین تأیید کند.";

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '➕ شارژ کیف پول', 'callback_data' => 'wallet:topup:start'],
                        ['text' => '🔄 بروزرسانی', 'callback_data' => 'wallet:refresh'],
                    ],
                ],
            ];

            if ($mid) editMessageText($chat_id, $mid, $msg, $kb);
            else sendMessage($chat_id, $msg, $kb);

            return;
        }

        
        // ===== مدیریت سرویس‌ها (حذف / تغییر نام) =====

                
        
        
        if (strpos($data, 'cfg:view:') === 0) {
            $config_id = (int)substr($data, strlen('cfg:view:'));
            $cfg = getUserConfigById($chat_id, $config_id, true);
            if (!$cfg) {
                if ($mid) editMessageText($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                else sendMessage($chat_id, "❌ کانفیگ یافت نشد.", userMenuKeyboard());
                return;
            }

            // متن جزئیات + کش مصرف
            $cache = getConfigUsageCache((int)$cfg['id']);
            $caption = buildServiceDetailsText($cfg, $cache);

            // QR برای لینک ساب
            $qr = makeQrUrl((string)$cfg['link'], 420);

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '✏️ تغییر نام', 'callback_data' => 'cfg:rename:' . (int)$config_id],
                        ['text' => '🗑 حذف', 'callback_data' => 'cfg:delete:' . (int)$config_id],
                    ],
                    [
                        ['text' => '🔙 بازگشت به سرویس‌ها', 'callback_data' => 'cfg:list'],
                    ],
                ],
            ];

            if ($qr === '') {
                sendMessage($chat_id, $caption, $kb);
                return;
            }

            sendPhoto($chat_id, $qr, $caption, $kb);
            return;
        }

        if ($data === 'cfg:list') {
            showUserServices($chat_id);
            return;
        }


        if (strpos($data, 'cfg:delete_confirm:') === 0) {
            $config_id = (int)substr($data, strlen('cfg:delete_confirm:'));
            $ok = deleteUserConfigHard($chat_id, $config_id);

            $msg = $ok ? "✅ کانفیگ حذف شد." : "❌ حذف کانفیگ ناموفق بود یا کانفیگ یافت نشد.";
            // ممکن است پیام فعلی عکس باشد (caption) و editMessageText خطا بدهد
            $edited = null;
            if ($mid) {
                if (isset($cb_message['text'])) {
                    $edited = editMessageText($chat_id, $mid, $msg);
                } else {
                    $edited = editMessageCaption($chat_id, $mid, $msg, null);
                }
            }
            if (!$mid || !$edited || empty($edited['ok'])) {
                sendMessage($chat_id, $msg, userMenuKeyboard());
            }

            // نمایش لیست جدید سرویس‌ها
            showUserServices($chat_id);
            return;
        }

        if (strpos($data, 'cfg:delete_cancel:') === 0) {
            $msg = "✅ حذف لغو شد.";
            $edited = null;
            if ($mid) {
                if (isset($cb_message['text'])) $edited = editMessageText($chat_id, $mid, $msg);
                else $edited = editMessageCaption($chat_id, $mid, $msg, null);
            }
            if (!$mid || !$edited || empty($edited['ok'])) {
                sendMessage($chat_id, $msg, userMenuKeyboard());
            }

            showUserServices($chat_id);
            return;
        }

        if (strpos($data, 'cfg:delete:') === 0) {
            $config_id = (int)substr($data, strlen('cfg:delete:'));
            $cfg = getUserConfigById($chat_id, $config_id, true);
            if (!$cfg) {
                $edited = null;
                if ($mid) {
                    if (isset($cb_message['text'])) $edited = editMessageText($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                    else $edited = editMessageCaption($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                }
                if (!$mid || !$edited || empty($edited['ok'])) {
                    sendMessage($chat_id, "❌ کانفیگ یافت نشد.", userMenuKeyboard());
                }
                return;
            }

            $msg = "🗑 حذف کانفیگ\n\n";
            $msg .= "نام: <b>" . htmlspecialchars($cfg['name']) . "</b>\n";
            $msg .= "حجم: <b>" . htmlspecialchars(formatPlanDataLabel((int)$cfg['data_gb'])) . "</b>\n\n";
            $msg .= "آیا مطمئن هستید؟";

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ بله، حذف شود', 'callback_data' => 'cfg:delete_confirm:' . (int)$config_id],
                        ['text' => '❌ لغو', 'callback_data' => 'cfg:delete_cancel:' . (int)$config_id],
                    ]
                ]
            ];

            // اگر پیام فعلی عکس/مدیا باشد، باید caption را ادیت کنیم
            $edited = null;
            if ($mid) {
                if (isset($cb_message['text'])) {
                    $edited = editMessageText($chat_id, $mid, $msg, $kb);
                } else {
                    $edited = editMessageCaption($chat_id, $mid, $msg, $kb);
                }
            }
            if (!$mid || !$edited || empty($edited['ok'])) {
                sendMessage($chat_id, $msg, $kb);
            }
            return;
        }

        if (strpos($data, 'cfg:rename:') === 0) {
            $config_id = (int)substr($data, strlen('cfg:rename:'));
            $cfg = getUserConfigById($chat_id, $config_id, true);
            if (!$cfg) {
                $edited = null;
                if ($mid) {
                    if (isset($cb_message['text'])) $edited = editMessageText($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                    else $edited = editMessageCaption($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                }
                if (!$mid || !$edited || empty($edited['ok'])) {
                    sendMessage($chat_id, "❌ کانفیگ یافت نشد.", userMenuKeyboard());
                }
                return;
            }

            clearState($chat_id);
            setState($chat_id, 'user_cfg_rename', ['config_id' => (int)$config_id]);

            $msg = "✏️ تغییر نام کانفیگ\n\n";
            $msg .= "نام فعلی: <b>" . htmlspecialchars($cfg['name']) . "</b>\n\n";
            $msg .= "نام جدید را ارسال کنید:\n(بین 2 تا 60 کاراکتر)\n\nبرای لغو: 🔙 بازگشت";

            sendMessage($chat_id, $msg, userMenuKeyboard());
            return;
        }

// ===== خرید: انتخاب گروه پلن‌ها =====
        if (strpos($data, 'buy:group:') === 0) {
            $grp = trim(substr($data, strlen('buy:group:')));

            if ($grp === 'cancel') {
                clearState($chat_id);
                if ($mid) editMessageText($chat_id, $mid, "❌ عملیات خرید لغو شد.");
                sendMessage($chat_id, "✅ به منو برگشتید.", userMenuKeyboard());
                return;
            }

            if ($grp === 'choose') {
                $kb = buildBuyGroupKeyboard();
                $txt = "🛒 خرید سرویس\n\nابتدا <b>گروه</b> را انتخاب کنید:";
                if ($mid) editMessageText($chat_id, $mid, $txt, $kb);
                else sendMessage($chat_id, $txt, $kb);
                return;
            }

            // اعتبارسنجی گروه (داینامیک)
            $validGroup = false;
            if (planGroupsTableExists()) {
                $g = getPlanGroupByKey($grp);
                $validGroup = (!empty($g) && (int)($g['active'] ?? 1) === 1);
            } else {
                $validGroup = ($grp === 'bulk' || $grp === 'vip');
            }

            if (!$validGroup) {
                if ($mid) editMessageText($chat_id, $mid, "❌ گروه نامعتبر است.");
                return;
            }

            // مرحله دوم: نمایش پلن‌های گروه انتخاب‌شده
            $plans = listActivePlansByGroup($grp);
            if (!$plans) {
                if ($mid) editMessageText($chat_id, $mid, "فعلاً هیچ پلنی در این گروه فعال نیست.");
                else sendMessage($chat_id, "فعلاً هیچ پلنی در این گروه فعال نیست.", userMenuKeyboard());
                return;
            }

            $rows = [];
            foreach ($plans as $p) {
                $priceHT = (int)round(((int)$p['price_toman']) / 1000);
                $volLabel = formatPlanDataLabel((int)$p['data_gb']);
                $uc = (int)($p['user_count'] ?? 2);
                $label = $volLabel . " | 👥 {$uc} کاربره | {$priceHT} هـ.ت";
                $rows[] = [[
                    'text' => $label,
                    'callback_data' => 'buy:plan:' . (int)$p['id'],
                ]];
            }
            // دکمه بازگشت به انتخاب گروه
            $rows[] = [[
                'text' => '⬅️ تغییر گروه',
                'callback_data' => 'buy:group:choose',
            ]];

            $kb = ['inline_keyboard' => $rows];
            $title = planGroupTitle($grp);
            $txt = "🛒 خرید سرویس\n\n";
            $txt .= "گروه انتخاب‌شده: <b>" . htmlspecialchars($title) . "</b>\n";
            $txt .= "پلن 1 ماهه »\n\n";
            $txt .= "یکی از پلن‌ها را انتخاب کنید:";

            if ($mid) editMessageText($chat_id, $mid, $txt, $kb);
            else sendMessage($chat_id, $txt, $kb);
            return;
        }

        // بازگشت به انتخاب گروه (دکمه «تغییر گروه»)
        if ($data === 'buy:group:choose') {
            $kb = buildBuyGroupKeyboard();
            $txt = "🛒 خرید سرویس\n\nابتدا <b>گروه</b> را انتخاب کنید:";
            if ($mid) editMessageText($chat_id, $mid, $txt, $kb);
            else sendMessage($chat_id, $txt, $kb);
            return;
        }



        if (strpos($data, 'buy:plan:') === 0) {
            $plan_id = (int)substr($data, strlen('buy:plan:'));
            $plan = getPlan($plan_id);
            if (!$plan || (int)$plan['active'] !== 1) {
                if ($mid) editMessageText($chat_id, $mid, "❌ پلن یافت نشد یا غیرفعال است.");
                return;
            }

            $payload = [
                'plan_id' => (int)$plan['id'],
                'title' => (string)$plan['title'],
                'data_gb' => (int)$plan['data_gb'],
                'duration_days' => (int)$plan['duration_days'],
                'price_toman' => (int)$plan['price_toman'],
                'plan_group_key' => (string)($plan['group_key'] ?? 'bulk'),
                'is_custom' => false,
            ];
            setState($chat_id, 'buy_wait_name', $payload);
            if ($mid) {
                editMessageText($chat_id, $mid, "✅ پلن انتخاب شد: <b>" . htmlspecialchars($plan['title']) . "</b>\n\nلطفاً یک نام برای سرویس وارد کنید (فارسی یا انگلیسی).");
            } else {
                sendMessage($chat_id, "لطفاً یک نام برای سرویس وارد کنید (فارسی یا انگلیسی).", userMenuKeyboard());
            }
            return;
        }

        if ($data === 'buy:custom') {
            // این قابلیت حذف/غیرفعال شده است (حجم دلخواه)
            clearState($chat_id);
            $msg = "❌ پلن حجم دلخواه غیرفعال شده است.\n\nلطفاً یکی از پلن‌های آماده را انتخاب کنید.";
            if ($mid) {
                editMessageText($chat_id, $mid, $msg);
            } else {
                sendMessage($chat_id, $msg, userMenuKeyboard());
            }
            return;
        }


        // ===== خرید: کد تخفیف / بروزرسانی / لغو / انتخاب روش پرداخت =====
        if ($data === 'buy:coupon') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'buy_payment') {
                if ($mid) editMessageText($chat_id, $mid, "❌ برای استفاده از کد تخفیف، ابتدا از منوی «خرید سرویس» وارد فرایند خرید شوید.");
                return;
            }
            $d = $st['data'] ?? [];
            setState($chat_id, 'buy_coupon_wait', $d);
            sendMessage($chat_id, "🎟 لطفاً کد تخفیف را ارسال کنید:");
            return;
        }

        if ($data === 'buy:refresh') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'buy_payment') return;
            $d = $st['data'] ?? [];
            $msg = buildBuyPaymentMessage($d);

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '🎟 کد تخفیف', 'callback_data' => 'buy:coupon'],
                        ['text' => '🔄 بروزرسانی', 'callback_data' => 'buy:refresh'],
                    ],
                    [
                        ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'buy:pay:card'],
                        ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'buy:pay:wallet'],
                    ],
                    [
                        ['text' => '❌ لغو', 'callback_data' => 'buy:cancel'],
                    ],
                ]
            ];
            if ($mid) editMessageText($chat_id, $mid, $msg, $kb);
            return;
        }

        if ($data === 'buy:cancel') {
            clearState($chat_id);
            if ($mid) editMessageText($chat_id, $mid, "❌ عملیات خرید لغو شد.");
            sendMessage($chat_id, "✅ به منو برگشتید.", userMenuKeyboard());
            return;
        }

        if ($data === 'buy:pay:card') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'buy_payment') {
                if ($mid) editMessageText($chat_id, $mid, "❌ این درخواست معتبر نیست.");
                return;
            }
            $d = $st['data'] ?? [];

            $conf = require __DIR__ . '/config.php';
            $timeoutMin = (int)($conf['ORDER_TIMEOUT_MINUTES'] ?? 15);
            $expires = time() + $timeoutMin * 60;

            setState($chat_id, 'buy_wait_receipt', $d, $expires);

            $card = getCardNumberValue();
            $holder = getCardHolderValue();

            $final = (int)($d['final_price_toman'] ?? $d['price_toman'] ?? 0);

            $msg = "💳 پرداخت کارت‌به‌کارت\n\n";
            $msg .= "مبلغ قابل پرداخت: <b>" . formatToman($final) . " تومان</b>\n";
            $msg .= "شماره کارت: <code>{$card}</code>\n";
            if ($holder !== '') $msg .= "به نام: <b>" . htmlspecialchars($holder) . "</b>\n";
            $msg .= "\n⏳ مهلت پرداخت: <b>{$timeoutMin} دقیقه</b>\n";
            $msg .= "پس از واریز، <b>فیش پرداخت</b> را به صورت عکس یا فایل همینجا ارسال کنید.";

            sendMessage($chat_id, $msg, userMenuKeyboard());
            return;
        }

        if ($data === 'buy:pay:wallet') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'buy_payment') {
                if ($mid) editMessageText($chat_id, $mid, "❌ این درخواست معتبر نیست.");
                return;
            }
            $d = $st['data'] ?? [];

            $user = getUserByChatId($chat_id);
            if (!$user) {
                clearState($chat_id);
                sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                return;
            }

            $final = (int)($d['final_price_toman'] ?? $d['price_toman'] ?? 0);
            if ($final < 0) $final = 0;

            $bal = getWalletBalanceByUserId((int)$user['id']);
            if ($bal < $final) {
                sendMessage($chat_id, "❌ موجودی کیف پول کافی نیست.\n\nموجودی شما: <b>" . formatToman($bal) . " تومان</b>\nمبلغ لازم: <b>" . formatToman($final) . " تومان</b>");
                return;
            }

            // برداشت از کیف پول
            $debit = walletDebit((int)$user['id'], $final, null, null, ['kind' => 'order', 'chat_id' => $chat_id]);
            if (empty($debit['ok'])) {
                sendMessage($chat_id, "❌ خطا در برداشت از کیف پول. لطفاً دوباره تلاش کنید.");
                return;
            }

            $pdo = db();
            $now = time();

	            $stmt = $pdo->prepare(
	                "INSERT INTO orders (user_id, config_name, protocol, plan_id, plan_group_key, plan_title, data_gb, duration_days, price_toman, payment_method, discount_code_id, discount_amount_toman, final_price_toman, wallet_tx_id, status, receipt_message_id, created_at, expires_at)\n" .
	                "VALUES (?,?,?,?,?,?,?,?,?,'wallet',?,?,?,?,'pending',NULL,?,NULL)"
	            );
	            $stmt->execute([
	                (int)$user['id'],
	                (string)($d['config_name'] ?? ''),
	                MAIN_PROTOCOL,
	                isset($d['plan_id']) ? $d['plan_id'] : null,
	                (string)($d['plan_group_key'] ?? 'bulk'),
	                (string)($d['title'] ?? ''),
	                (int)($d['data_gb'] ?? 0),
	                (int)($d['duration_days'] ?? 0),
	                (int)($d['base_price_toman'] ?? $d['price_toman'] ?? 0),
	                !empty($d['discount_code_id']) ? (int)$d['discount_code_id'] : null,
	                (int)($d['discount_amount_toman'] ?? 0),
	                $final,
	                (int)($debit['tx_id'] ?? 0),
	                $now,
	            ]);
            $order_id = (int)$pdo->lastInsertId();

            // لینک کردن تراکنش کیف پول به سفارش
            if (!empty($debit['tx_id'])) {
                $pdo->prepare("UPDATE wallet_transactions SET order_id=? WHERE id=?")->execute([$order_id, (int)$debit['tx_id']]);
            }

            // اطلاع به ادمین (بدون فیش)
            $uname = $user['username'] ? '@' . $user['username'] : '—';
            $details = "🧩 سفارش خرید جدید #{$order_id}\n";
            $details .= formatUserLine($user) . "\n";
            $details .= "یوزرنیم: <b>{$uname}</b>\n\n";
            $details .= "روش پرداخت: <b>کیف پول</b>\n";
            $details .= "نام سرویس: <b>" . htmlspecialchars($d['config_name'] ?? '') . "</b>\n";
            $details .= "پروتکل: <b>" . MAIN_PROTOCOL . "</b>\n";
            $details .= "حجم: <b>" . htmlspecialchars(formatPlanDataLabel((int)($d['data_gb'] ?? 0))) . "</b>\n";
            $details .= "مدت: <b>" . (int)($d['duration_days'] ?? 0) . " روز</b>\n";
            if (!empty($d['discount_amount_toman'])) {
                $details .= "قیمت پایه: <b>" . formatToman((int)($d['base_price_toman'] ?? 0)) . " تومان</b>\n";
                $details .= "تخفیف: <b>" . formatToman((int)($d['discount_amount_toman'] ?? 0)) . " تومان</b>\n";
            }
            $details .= "مبلغ نهایی: <b>" . formatToman($final) . " تومان</b>\n";
            $gk = (string)($d['plan_group_key'] ?? 'bulk');
            $details .= "گروه: <b>" . htmlspecialchars(planGroupTitle($gk)) . "</b>\n";
            $details .= "پلن: <b>" . htmlspecialchars($d['title'] ?? '—') . "</b>";

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '📤 ارسال کانفیگ', 'callback_data' => 'admin:order:sendcfg:' . $order_id],
                        ['text' => 'رد سفارش', 'callback_data' => 'admin:order:reject:' . $order_id],
                    ]
                ]
            ];
            sendMessage(ADMIN_ID, $details, $kb);

            clearState($chat_id);
            sendMessage($chat_id, "✅ مبلغ از کیف پول شما کسر شد و سفارش برای تأیید ادمین ارسال شد.\nپس از تأیید، سرویس برای شما ارسال می‌شود.", userMenuKeyboard());
            return;
        }

if (strpos($data, 'renew:select:') === 0) {
            $config_id = (int)substr($data, strlen('renew:select:'));
            $user = getUserByChatId($chat_id);
            if (!$user) {
                if ($mid) editMessageText($chat_id, $mid, "❌ کاربر یافت نشد.");
                return;
            }

            $pdo = db();
            $stmt = $pdo->prepare("SELECT * FROM configs WHERE id=? AND user_id=? AND active=1 LIMIT 1");
            $stmt->execute([$config_id, (int)$user['id']]);
            $cfg = $stmt->fetch();
            if (!$cfg) {
                if ($mid) editMessageText($chat_id, $mid, "❌ کانفیگ یافت نشد.");
                return;
            }

            $basePrice = (int)($cfg['price_toman'] ?? 0);
            if ($basePrice <= 0) $basePrice = 0;

            $payload = [
                'config_id' => $config_id,
                'base_price_toman' => $basePrice,
                'discount_code_id' => null,
                'discount_code' => null,
                'discount_amount_toman' => 0,
                'final_price_toman' => $basePrice,
            ];

            $msg = buildRenewPaymentMessage($cfg, $payload);

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '🎟 کد تخفیف', 'callback_data' => 'renew:coupon'],
                        ['text' => '🔄 بروزرسانی', 'callback_data' => 'renew:refresh'],
                    ],
                    [
                        ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'renew:pay:card'],
                        ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'renew:pay:wallet'],
                    ],
                    [
                        ['text' => '❌ لغو', 'callback_data' => 'renew:cancel'],
                    ],
                ]
            ];

            // پیام را ادیت می‌کنیم و message_id همان mid است
            if ($mid) {
                editMessageText($chat_id, $mid, $msg, $kb);
                $payload['pay_msg_id'] = $mid;
            } else {
                $sent = sendMessage($chat_id, $msg, $kb);
                $payload['pay_msg_id'] = (!empty($sent['ok']) && !empty($sent['result']['message_id'])) ? (int)$sent['result']['message_id'] : null;
            }

            setState($chat_id, 'renew_payment', $payload);
            return;
        }

        // ===== تمدید: کد تخفیف / بروزرسانی / لغو / انتخاب روش پرداخت =====
        if ($data === 'renew:coupon') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'renew_payment') return;
            $d = $st['data'] ?? [];
            setState($chat_id, 'renew_coupon_wait', $d);
            sendMessage($chat_id, "🎟 لطفاً کد تخفیف را ارسال کنید:");
            return;
        }

        if ($data === 'renew:refresh') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'renew_payment') return;
            $d = $st['data'] ?? [];

            $user = getUserByChatId($chat_id);
            if (!$user) return;

            $pdo = db();
            $stmt = $pdo->prepare("SELECT * FROM configs WHERE id=? AND user_id=? LIMIT 1");
            $stmt->execute([(int)($d['config_id'] ?? 0), (int)$user['id']]);
            $cfg = $stmt->fetch();
            if (!$cfg) return;

            $msg = buildRenewPaymentMessage($cfg, $d);

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '🎟 کد تخفیف', 'callback_data' => 'renew:coupon'],
                        ['text' => '🔄 بروزرسانی', 'callback_data' => 'renew:refresh'],
                    ],
                    [
                        ['text' => '💳 پرداخت کارت‌به‌کارت', 'callback_data' => 'renew:pay:card'],
                        ['text' => '💰 پرداخت با کیف پول', 'callback_data' => 'renew:pay:wallet'],
                    ],
                    [
                        ['text' => '❌ لغو', 'callback_data' => 'renew:cancel'],
                    ],
                ]
            ];

            if ($mid) editMessageText($chat_id, $mid, $msg, $kb);
            return;
        }

        if ($data === 'renew:cancel') {
            clearState($chat_id);
            if ($mid) editMessageText($chat_id, $mid, "❌ عملیات تمدید لغو شد.");
            sendMessage($chat_id, "✅ به منو برگشتید.", userMenuKeyboard());
            return;
        }

        if ($data === 'renew:pay:card') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'renew_payment') return;
            $d = $st['data'] ?? [];

            $conf = require __DIR__ . '/config.php';
            $timeoutMin = (int)($conf['ORDER_TIMEOUT_MINUTES'] ?? 15);
            $expires = time() + $timeoutMin * 60;

            setState($chat_id, 'renew_wait_receipt', $d, $expires);

            $card = getCardNumberValue();
            $holder = getCardHolderValue();

            $final = (int)($d['final_price_toman'] ?? $d['base_price_toman'] ?? 0);

            $msg = "💳 پرداخت کارت‌به‌کارت (تمدید)\n\n";
            $msg .= "مبلغ قابل پرداخت: <b>" . formatToman($final) . " تومان</b>\n";
            $msg .= "شماره کارت: <code>{$card}</code>\n";
            if ($holder !== '') $msg .= "به نام: <b>" . htmlspecialchars($holder) . "</b>\n";
            $msg .= "\n⏳ مهلت پرداخت: <b>{$timeoutMin} دقیقه</b>\n";
            $msg .= "پس از واریز، <b>فیش پرداخت</b> را به صورت عکس یا فایل ارسال کنید.";

            sendMessage($chat_id, $msg, userMenuKeyboard());
            return;
        }

        if ($data === 'renew:pay:wallet') {
            $st = getState($chat_id);
            if (!$st || ($st['state'] ?? '') !== 'renew_payment') return;
            $d = $st['data'] ?? [];

            $user = getUserByChatId($chat_id);
            if (!$user) {
                clearState($chat_id);
                sendMessage($chat_id, "❌ خطا در شناسایی کاربر. دوباره /start را بزنید.", userMenuKeyboard());
                return;
            }

            $pdo = db();
            $cfgQ = $pdo->prepare("SELECT * FROM configs WHERE id=? AND user_id=? LIMIT 1");
            $cfgQ->execute([(int)($d['config_id'] ?? 0), (int)$user['id']]);
            $cfgRow = $cfgQ->fetch();
            if (!$cfgRow) {
                clearState($chat_id);
                sendMessage($chat_id, "❌ کانفیگ انتخاب‌شده یافت نشد.", userMenuKeyboard());
                return;
            }

            $final = (int)($d['final_price_toman'] ?? $d['base_price_toman'] ?? 0);
            if ($final < 0) $final = 0;

            $bal = getWalletBalanceByUserId((int)$user['id']);
            if ($bal < $final) {
                sendMessage($chat_id, "❌ موجودی کیف پول کافی نیست.\n\nموجودی شما: <b>" . formatToman($bal) . " تومان</b>\nمبلغ لازم: <b>" . formatToman($final) . " تومان</b>");
                return;
            }

            $debit = walletDebit((int)$user['id'], $final, null, null, ['kind' => 'renewal', 'chat_id' => $chat_id, 'config_id' => (int)$cfgRow['id']]);
            if (empty($debit['ok'])) {
                sendMessage($chat_id, "❌ خطا در برداشت از کیف پول. لطفاً دوباره تلاش کنید.");
                return;
            }

            $now = time();
            $stmt = $pdo->prepare("INSERT INTO renewals (user_id, config_id, status, receipt_message_id, created_at, price_toman, payment_method, discount_code_id, discount_amount_toman, final_price_toman, wallet_tx_id) VALUES (?,?, 'pending', NULL, ?, ?, 'wallet', ?, ?, ?, ?)");
            $stmt->execute([
                (int)$user['id'],
                (int)$cfgRow['id'],
                $now,
                (int)($d['base_price_toman'] ?? 0),
                !empty($d['discount_code_id']) ? (int)$d['discount_code_id'] : null,
                (int)($d['discount_amount_toman'] ?? 0),
                $final,
                (int)($debit['tx_id'] ?? 0),
            ]);
            $renewal_id = (int)$pdo->lastInsertId();

            if (!empty($debit['tx_id'])) {
                $pdo->prepare("UPDATE wallet_transactions SET renewal_id=? WHERE id=?")->execute([$renewal_id, (int)$debit['tx_id']]);
            }

            $details = "🔁 درخواست تمدید #{$renewal_id}\n";
            $details .= formatUserLine($user) . "\n\n";
            $details .= "روش پرداخت: <b>کیف پول</b>\n";
            $details .= "کانفیگ: <b>" . htmlspecialchars($cfgRow['name']) . "</b>\n";
            if (!empty($d['discount_amount_toman'])) {
                $details .= "قیمت پایه: <b>" . formatToman((int)($d['base_price_toman'] ?? 0)) . " تومان</b>\n";
                $details .= "تخفیف: <b>" . formatToman((int)($d['discount_amount_toman'] ?? 0)) . " تومان</b>\n";
            }
            $details .= "مبلغ نهایی: <b>" . formatToman($final) . " تومان</b>\n";
            $details .= "لینک کانفیگ:\n<code>" . htmlspecialchars($cfgRow['link']) . "</code>\n";

            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ تأیید تمدید', 'callback_data' => 'admin:renew:approve:' . $renewal_id],
                        ['text' => 'رد درخواست', 'callback_data' => 'admin:renew:reject:' . $renewal_id],
                    ]
                ]
            ];
            sendMessage(ADMIN_ID, $details, $kb);

            clearState($chat_id);
            sendMessage($chat_id, "✅ مبلغ از کیف پول شما کسر شد و درخواست تمدید برای تأیید ادمین ارسال شد.", userMenuKeyboard());
            return;
        }

        return; // سایر کال‌بک‌ها برای کاربر
    }

    // --- ADMIN CALLBACKS ---
    if (!isAdmin($chat_id)) return;

    // noop برای دکمه‌های غیرفعال/نمایشی
    if ($data === 'noop') return;

    // =========================
    // 🎟 تخفیف گروه خاص - Callback ها
    // =========================
    if ($data === 'admin:discount:back_to_menu') {
        // فقط برگرد به منوی تخفیف
        sendMessage($chat_id, "🎟 مدیریت کد تخفیف

یکی از گزینه‌ها را انتخاب کنید:", adminDiscountMenuKeyboard());
        return;
    }

    if (strpos($data, 'admin:discount:group_select:') === 0) {
        $groupKey = substr($data, strlen('admin:discount:group_select:'));
        $g = getPlanGroupByKey($groupKey);
        if (!$g) {
            sendMessage($chat_id, "❌ گروه یافت نشد.", adminDiscountMenuKeyboard());
            return;
        }
        $title = (string)($g['title'] ?? $groupKey);

        $codes = listDiscountCodesAll();
        if (!$codes) {
            $kb = [
                'inline_keyboard' => [
                    [
                        ['text' => '⬅️ بازگشت', 'callback_data' => 'admin:discount:back_to_menu'],
                    ]
                ]
            ];
            sendMessage($chat_id, "🎯 گروه: <b>" . htmlspecialchars($title) . "</b>

❌ کد تخفیفی موجود نیست.", $kb);
            return;
        }

        $map = getDiscountGroupMap();
        $currentId = isset($map[strtolower($groupKey)]) ? (int)$map[strtolower($groupKey)] : 0;

        $ik = [];
        foreach ($codes as $c) {
            $cid = (int)($c['id'] ?? 0);
            $code = (string)($c['code'] ?? '');
            if ($cid <= 0 || $code === '') continue;
            $mark = ($currentId === $cid) ? ' ✅' : '';
            $ik[] = [[
                'text' => '🎟 ' . $code . $mark,
                'callback_data' => 'admin:discount:group_assign:' . $groupKey . ':' . $cid,
            ]];
        }
        $ik[] = [[
            'text' => '🚫 حذف تخفیف این گروه',
            'callback_data' => 'admin:discount:group_remove:' . $groupKey,
        ]];
        $ik[] = [[
            'text' => '⬅️ بازگشت',
            'callback_data' => 'admin:discount:back_to_menu',
        ]];

        sendMessage($chat_id, "🎯 گروه: <b>" . htmlspecialchars($title) . "</b>

کدام کد تخفیف را می‌خواهید فقط برای این گروه اعمال شود؟", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:discount:group_assign:') === 0) {
        $rest = substr($data, strlen('admin:discount:group_assign:'));
        // groupKey:codeId
        $parts = explode(':', $rest);
        $groupKey = $parts[0] ?? '';
        $codeId = isset($parts[1]) ? (int)$parts[1] : 0;
        if ($groupKey === '' || $codeId <= 0) {
            sendMessage($chat_id, "❌ اطلاعات نامعتبر.", adminDiscountMenuKeyboard());
            return;
        }

        $ok = assignDiscountCodeToGroup($groupKey, $codeId);
        if ($ok) {
            answerCallbackQuery($cb_id, '✅ ثبت شد');
        }
        // نمایش مجدد لیست کدها
        $fakeCb = ['from' => ['id' => $chat_id], 'id' => $cb_id, 'data' => 'admin:discount:group_select:' . $groupKey, 'message' => ['message_id' => $mid]];
        // با ارسال پیام جدید (ساده‌تر)
        $g = getPlanGroupByKey($groupKey);
        $title = $g ? (string)($g['title'] ?? $groupKey) : $groupKey;
        sendMessage($chat_id, "✅ کد تخفیف برای گروه <b>" . htmlspecialchars($title) . "</b> ثبت شد.", adminDiscountMenuKeyboard());
        return;
    }

    if (strpos($data, 'admin:discount:group_remove:') === 0) {
        $groupKey = substr($data, strlen('admin:discount:group_remove:'));
        if ($groupKey === '') {
            sendMessage($chat_id, "❌ اطلاعات نامعتبر.", adminDiscountMenuKeyboard());
            return;
        }
        removeDiscountFromGroup($groupKey);
        $g = getPlanGroupByKey($groupKey);
        $title = $g ? (string)($g['title'] ?? $groupKey) : $groupKey;
        sendMessage($chat_id, "✅ تخفیف گروه <b>" . htmlspecialchars($title) . "</b> حذف شد.", adminDiscountMenuKeyboard());
        return;
    }

    // =========================
    // ⛔️ خاموش/روشن گروه - Callback ها
    // =========================
    if ($data === 'admin:cfg:toggle_group:back') {
        clearState($chat_id);
        setState($chat_id, 'admin_cfg_manage_menu');
        sendMessage($chat_id, "🗂 مدیریت کانفیگ‌ها

یکی از گزینه‌ها را انتخاب کنید:", adminConfigManageKeyboard());
        return;
    }

    if (strpos($data, 'admin:cfg:toggle_group:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:toggle_group:'));
        if ($groupKey === '' || $groupKey === 'back') {
            sendMessage($chat_id, "❌ گروه نامعتبر.", adminConfigManageKeyboard());
            return;
        }
        $g = getPlanGroupByKey($groupKey);
        if (!$g) {
            sendMessage($chat_id, "❌ گروه یافت نشد.", adminConfigManageKeyboard());
            return;
        }
        $active = (int)($g['active'] ?? 1);
        $newActive = $active ? 0 : 1;
        setPlanGroupActive($groupKey, $newActive);

        $title = (string)($g['title'] ?? $groupKey);
        $msg = $newActive ? "✅ گروه «{$title}» روشن شد." : "⛔️ گروه «{$title}» خاموش شد و به کاربر نمایش داده نمی‌شود.";
        answerCallbackQuery($cb_id, $newActive ? '✅ روشن شد' : '⛔️ خاموش شد');
        sendMessage($chat_id, $msg, adminConfigManageKeyboard());
        return;
    }


    // =========================
    // 🗂 مدیریت کانفیگ‌ها - Callback ها
    // =========================
    if ($data === 'admin:cfg:edit:back_to_menu') {
        clearState($chat_id);
        setState($chat_id, 'admin_cfg_manage_menu');
        sendMessage($chat_id, "🗂 مدیریت کانفیگ‌ها\n\nیکی از گزینه‌ها را انتخاب کنید:", adminConfigManageKeyboard());
        return;
    }

    if ($data === 'admin:cfg:del:back_to_delete_menu') {
        clearState($chat_id);
        setState($chat_id, 'admin_cfg_delete_menu');
        sendMessage($chat_id, "🗑 حذف\n\nیکی از گزینه‌ها را انتخاب کنید:", adminConfigDeleteKeyboard());
        return;
    }

    if (strpos($data, 'admin:cfg:edit:select_group:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:edit:select_group:'));
        $g = getPlanGroupByKey($groupKey);
        if (!$g) {
            sendMessage($chat_id, "❌ گروه یافت نشد.", adminConfigManageKeyboard());
            return;
        }

        $title = (string)($g['title'] ?? $groupKey);

        $ik = [
            [
                ['text' => '✏️ ویرایش نام گروه', 'callback_data' => 'admin:cfg:edit:group_name:' . $groupKey],
            ],
            [
                ['text' => '🧾 ویرایش پلن‌های گروه', 'callback_data' => 'admin:cfg:edit:plans:' . $groupKey],
            ],
            [
                ['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:edit:back_to_menu'],
            ],
        ];

        sendMessage($chat_id, "🗂 <b>{$title}</b>\n\nچه چیزی را می‌خواهید ویرایش کنید؟", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:cfg:edit:group_name:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:edit:group_name:'));
        $g = getPlanGroupByKey($groupKey);
        if (!$g) {
            sendMessage($chat_id, "❌ گروه یافت نشد.", adminConfigManageKeyboard());
            return;
        }
        $curTitle = (string)($g['title'] ?? $groupKey);

        clearState($chat_id);
        setState($chat_id, 'admin_cfg_edit_group_title', ['group_key' => $groupKey]);

        sendMessage($chat_id, "✏️ ویرایش نام گروه\n\nنام فعلی: <b>" . htmlspecialchars($curTitle) . "</b>\n\n📝 نام جدید را ارسال کنید:", adminConfigManageKeyboard());
        return;
    }

    if (strpos($data, 'admin:cfg:edit:plans:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:edit:plans:'));
        $pdo = db();
        $stmt = $pdo->prepare("SELECT * FROM plans WHERE group_key=? ORDER BY id ASC");
        $stmt->execute([$groupKey]);
        $plans = $stmt->fetchAll();

        if (!$plans) {
            sendMessage($chat_id, "ℹ️ پلنی برای این گروه وجود ندارد.", adminConfigManageKeyboard());
            return;
        }

        $ik = [];
        foreach ($plans as $p) {
            $pid = (int)$p['id'];
            $title = (string)$p['title'];
            $ik[] = [['text' => "🧾 {$title}", 'callback_data' => 'admin:cfg:edit:plan:' . $pid]];
        }
        $ik[] = [['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:edit:back_to_menu']];

        sendMessage($chat_id, "🧾 <b>پلن‌های گروه</b>\n\nیک پلن را انتخاب کنید:", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:cfg:edit:plan:') === 0) {
        $planId = (int)substr($data, strlen('admin:cfg:edit:plan:'));
        $pdo = db();
        $q = $pdo->prepare("SELECT * FROM plans WHERE id=? LIMIT 1");
        $q->execute([$planId]);
        $p = $q->fetch();

        if (!$p) {
            sendMessage($chat_id, "❌ پلن یافت نشد.", adminConfigManageKeyboard());
            return;
        }

        $curTitle = (string)$p['title'];
        $curGb = (int)$p['data_gb'];
        $curDays = (int)$p['duration_days'];
        $curUc = (int)($p['user_count'] ?? 2);
        $curPrice = (int)$p['price_toman'];

        clearState($chat_id);
        setState($chat_id, 'admin_cfg_edit_plan_wait_title', [
            'plan_id' => $planId,
        ]);

        $msg = "✏️ <b>ویرایش پلن</b>\n\n";
        $msg .= "🧾 عنوان فعلی: <b>" . htmlspecialchars($curTitle) . "</b>\n";
        $msg .= "📦 حجم فعلی: <b>" . htmlspecialchars(formatPlanDataLabel($curGb)) . "</b>\n";
        $msg .= "⏳ مدت فعلی: <b>{$curDays} روز</b>\n";
        $msg .= "👥 کاربر فعلی: <b>{$curUc}</b>\n";
        $msg .= "💰 قیمت فعلی: <b>" . formatToman($curPrice) . "</b> تومان\n\n";
        $msg .= "📝 عنوان جدید را ارسال کنید یا برای بدون تغییر: <code>-</code>";

        sendMessage($chat_id, $msg, adminConfigManageKeyboard());
        return;
    }

    // -------- حذف گروه --------
    if (strpos($data, 'admin:cfg:del:group:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:del:group:'));
        $g = getPlanGroupByKey($groupKey);
        if (!$g) {
            sendMessage($chat_id, "❌ گروه یافت نشد.", adminConfigDeleteKeyboard());
            return;
        }
        $title = (string)($g['title'] ?? $groupKey);

        $ik = [
            [
                ['text' => '✅ حذف گروه', 'callback_data' => 'admin:cfg:del:group_confirm:' . $groupKey],
                ['text' => '❌ لغو', 'callback_data' => 'admin:cfg:del:back_to_delete_menu'],
            ],
        ];

        sendMessage($chat_id, "🗂 <b>حذف گروه</b>\n\nآیا از حذف گروه زیر مطمئن هستید؟\n<b>" . htmlspecialchars($title) . "</b>\n\n⚠️ با حذف گروه، تمام <b>پلن‌های</b> آن هم حذف می‌شوند.", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:cfg:del:group_confirm:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:del:group_confirm:'));
        $res = deletePlanGroupCascade($groupKey);

        clearState($chat_id);
        setState($chat_id, 'admin_cfg_delete_menu');

        if (!empty($res['ok'])) {
            sendMessage(
                $chat_id,
                "✅ گروه حذف شد. 🗑\n\n🧾 پلن‌های حذف‌شده: <b>" . (int)$res['plans_deleted'] . "</b>\n🗂 گروه‌های حذف‌شده: <b>" . (int)$res['group_deleted'] . "</b>",
                adminConfigDeleteKeyboard()
            );
        } else {
            sendMessage($chat_id, "❌ حذف گروه ناموفق بود.", adminConfigDeleteKeyboard());
        }
        return;
    }

    // -------- حذف پلن --------
    if (strpos($data, 'admin:cfg:del:plan_group:') === 0) {
        $groupKey = substr($data, strlen('admin:cfg:del:plan_group:'));
        $pdo = db();
        $stmt = $pdo->prepare("SELECT * FROM plans WHERE group_key=? ORDER BY id ASC");
        $stmt->execute([$groupKey]);
        $plans = $stmt->fetchAll();

        if (!$plans) {
            sendMessage($chat_id, "ℹ️ پلنی برای این گروه وجود ندارد.", adminConfigDeleteKeyboard());
            return;
        }

        $ik = [];
        foreach ($plans as $p) {
            $pid = (int)$p['id'];
            $title = (string)$p['title'];
            $ik[] = [
                ['text' => "🧾 {$title}", 'callback_data' => 'admin:cfg:del:plan:' . $pid],
            ];
        }
        $ik[] = [['text' => '⬅️ بازگشت', 'callback_data' => 'admin:cfg:del:back_to_delete_menu']];

        sendMessage($chat_id, "🧾 <b>حذف پلن</b>\n\nیک پلن را برای حذف انتخاب کنید:", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:cfg:del:plan:') === 0) {
        $planId = (int)substr($data, strlen('admin:cfg:del:plan:'));
        $pdo = db();
        $q = $pdo->prepare("SELECT * FROM plans WHERE id=? LIMIT 1");
        $q->execute([$planId]);
        $p = $q->fetch();
        if (!$p) {
            sendMessage($chat_id, "❌ پلن یافت نشد.", adminConfigDeleteKeyboard());
            return;
        }

        $ik = [
            [
                ['text' => '✅ حذف پلن', 'callback_data' => 'admin:cfg:del:plan_confirm:' . $planId],
                ['text' => '❌ لغو', 'callback_data' => 'admin:cfg:del:back_to_delete_menu'],
            ],
        ];

        sendMessage($chat_id, "🧾 <b>حذف پلن</b>\n\nآیا از حذف این پلن مطمئن هستید؟\n<b>" . htmlspecialchars((string)$p['title']) . "</b>", ['inline_keyboard' => $ik]);
        return;
    }

    if (strpos($data, 'admin:cfg:del:plan_confirm:') === 0) {
        $planId = (int)substr($data, strlen('admin:cfg:del:plan_confirm:'));
        $pdo = db();
        $st = $pdo->prepare("DELETE FROM plans WHERE id=?");
        $st->execute([$planId]);
        $n = (int)$st->rowCount();

        clearState($chat_id);
        setState($chat_id, 'admin_cfg_delete_menu');

        if ($n > 0) {
            sendMessage($chat_id, "✅ پلن حذف شد. 🗑", adminConfigDeleteKeyboard());
        } else {
            sendMessage($chat_id, "❌ حذف پلن ناموفق بود.", adminConfigDeleteKeyboard());
        }
        return;
    }


    // صفحه‌بندی لیست کاربران
    if (strpos($data, 'admin:users:list:') === 0) {
        $page = (int)substr($data, strlen('admin:users:list:'));
        if ($page < 1) $page = 1;

        $p = adminUsersListPayload($page, 20);
        if ($mid) {
            editMessageText($chat_id, $mid, $p['text'], $p['kb']);
        } else {
            sendMessage($chat_id, $p['text'], $p['kb']);
        }
        return;
    }

    // مسدود/رفع مسدود کاربر از داخل لیست کاربران
    // الگو: admin:users:toggle:<user_id>:<page>
    if (strpos($data, 'admin:users:toggle:') === 0) {
        $parts = explode(':', $data);
        $userId = isset($parts[3]) ? (int)$parts[3] : 0;
        $page = isset($parts[4]) ? (int)$parts[4] : 1;
        if ($page < 1) $page = 1;

        if ($userId < 1) {
            return;
        }

        $pdo = db();
        $q = $pdo->prepare("SELECT id, chat_id, is_blocked FROM users WHERE id=? LIMIT 1");
        $q->execute([$userId]);
        $u = $q->fetch();
        if (!$u) {
            // رفرش لیست در صورت حذف/عدم وجود
            $p = adminUsersListPayload($page, 20);
            if ($mid) editMessageText($chat_id, $mid, $p['text'], $p['kb']);
            return;
        }

        $wasBlocked = ((int)($u['is_blocked'] ?? 0) === 1);
        $newBlocked = $wasBlocked ? 0 : 1;
        $pdo->prepare("UPDATE users SET is_blocked=? WHERE id=?")->execute([$newBlocked, $userId]);

        $targetChat = (int)$u['chat_id'];

        // پاک کردن state کاربر (برای جلوگیری از ادامه روندهای قبلی)
        if ($targetChat > 0) {
            clearState($targetChat);
        }

        // اطلاع به کاربر (ادمین را نوتیفای نکن)
        if ($targetChat > 0 && $targetChat !== (int)ADMIN_ID) {
            if ($newBlocked === 1) {
                sendMessage($targetChat, "⛔️ دسترسی شما توسط ادمین مسدود شد.");
            } else {
                sendMessage($targetChat, "✅ مسدودی شما رفع شد. برای شروع، /start را بزنید.", userMenuKeyboard());
            }
        }

        // رفرش لیست کاربران
        $p = adminUsersListPayload($page, 20);
        if ($mid) {
            editMessageText($chat_id, $mid, $p['text'], $p['kb']);
        } else {
            sendMessage($chat_id, $p['text'], $p['kb']);
        }
        return;
    }

    // =========================
    // کانفیگ رایگان (پنل ادمین)
    // =========================
    if ($data === 'admin:freecfg:toggle') {
        $current = freeConfigIsEnabled();
        $new = $current ? 0 : 1;

        $ok = setBotSetting('free_config_enabled', (string)$new);
        if (!$ok) {
            if ($mid) editMessageText($chat_id, $mid, "❌ تغییر وضعیت ناموفق بود. (ابتدا جدول settings را بسازید)");
            else sendMessage($chat_id, "❌ تغییر وضعیت ناموفق بود. (ابتدا جدول settings را بسازید)", adminMenuKeyboard());
            return;
        }

        $p = adminFreeConfigPanelPayload();
        if ($mid) editMessageText($chat_id, $mid, $p['text'], $p['kb']);
        else sendMessage($chat_id, $p['text'], $p['kb']);
        return;
    }

    if ($data === 'admin:freecfg:setlink') {
        clearState($chat_id);
        setState($chat_id, 'admin_freecfg_wait_link');
        $p = adminFreeConfigPanelPayload();
        $txt = "🔗 لطفاً <b>لینک ساب رایگان</b> را ارسال کنید:\n\n" . $p['text'];
        // بعضی کلاینت‌ها/شرایط، ادیت پیام را نشان نمی‌دهند یا ممکن است ادیت بخورد.
        // برای اینکه «تنظیم لینک» همیشه واکنش قابل مشاهده داشته باشد، اگر ادیت موفق نبود، پیام جدید می‌فرستیم.
        $edited = null;
        if ($mid) {
            $edited = editMessageText($chat_id, $mid, $txt, $p['kb']);
        }
        if (!$mid || !$edited || empty($edited['ok'])) {
            sendMessage($chat_id, $txt, $p['kb']);
        }
        return;
    }

    if ($data === 'admin:freecfg:refresh') {
        $p = adminFreeConfigPanelPayload();
        if ($mid) editMessageText($chat_id, $mid, $p['text'], $p['kb']);
        else sendMessage($chat_id, $p['text'], $p['kb']);
        return;
    }

    // =========================
    // اسپانسر / جوین اجباری (پنل ادمین)
    // =========================
    if ($data === 'admin:sponsor:add') {
        clearState($chat_id);
        setState($chat_id, 'admin_sponsor_wait_channel');

        $prompt = "📣 لطفاً لینک/آیدی کانال اسپانسر را ارسال کنید:

" .
            "✅ فرمت‌های قابل قبول:
" .
            "• <code>@channel</code>
" .
            "• <code>https://t.me/channel</code>
" .
            "• <code>-1001234567890</code>

" .
            "⚠️ لینک‌های خصوصی مثل <code>t.me/+...</code> قابل چک کردن نیستند.";

        $edited = null;
        if ($mid) {
            $edited = editMessageText($chat_id, $mid, $prompt, null);
        }
        if (!$mid || !$edited || empty($edited['ok'])) {
            sendMessage($chat_id, $prompt, adminMenuKeyboard());
        }
        return;
    }

    if ($data === 'admin:sponsor:refresh' || $data === 'admin:sponsor:back') {
        $p = adminSponsorPanelPayload();
        if ($mid) editMessageText($chat_id, $mid, $p['text'], $p['kb']);
        else sendMessage($chat_id, $p['text'], $p['kb']);
        return;
    }

    if ($data === 'admin:sponsor:delete_menu') {
        $items = getJoinRequiredChannelsItems();
        if (empty($items)) {
            $p = adminSponsorPanelPayload();
            if ($mid) editMessageText($chat_id, $mid, "⛔️ هیچ کانالی برای حذف وجود ندارد.

" . $p['text'], $p['kb']);
            else sendMessage($chat_id, "⛔️ هیچ کانالی برای حذف وجود ندارد.

" . $p['text'], $p['kb']);
            return;
        }

        $txt = "🗑 <b>حذف اسپانسر</b>

";
        $txt .= "روی کانال مورد نظر برای حذف کلیک کنید:";

        $kbRows = [];
        foreach ($items as $it) {
            $ch = (string)($it['channel'] ?? '');
            $btn = (string)($it['button_text'] ?? $ch);
            $hash = md5($ch);
            $kbRows[] = [
                ['text' => "🗑 " . $btn, 'callback_data' => "admin:sponsor:del:" . $hash],
            ];
        }
        $kbRows[] = [
            ['text' => '⬅️ بازگشت', 'callback_data' => 'admin:sponsor:back'],
        ];

        $kb = ['inline_keyboard' => $kbRows];
        if ($mid) editMessageText($chat_id, $mid, $txt, $kb);
        else sendMessage($chat_id, $txt, $kb);
        return;
    }

    if (strpos($data, 'admin:sponsor:del:') === 0) {
        $hash = substr($data, strlen('admin:sponsor:del:'));
        $items = getJoinRequiredChannelsItems();

        $newItems = [];
        $removed = null;
        foreach ($items as $it) {
            $ch = (string)($it['channel'] ?? '');
            if ($ch !== '' && md5($ch) === $hash && $removed === null) {
                $removed = $it;
                continue;
            }
            $newItems[] = $it;
        }

        $ok = setJoinRequiredChannelsItems($newItems);
        if (!$ok) {
            if ($mid) editMessageText($chat_id, $mid, "❌ حذف ناموفق بود.");
            else sendMessage($chat_id, "❌ حذف ناموفق بود.", adminMenuKeyboard());
            return;
        }

        $p = adminSponsorPanelPayload();
        $msg = $removed ? "✅ کانال حذف شد.

" : "✅ بروزرسانی شد.

";
        if ($mid) editMessageText($chat_id, $mid, $msg . $p['text'], $p['kb']);
        else sendMessage($chat_id, $msg . $p['text'], $p['kb']);
        return;
    }

    if (strpos($data, 'admin:order:sendcfg:') === 0) {
        $order_id = (int)substr($data, strlen('admin:order:sendcfg:'));
        setState($chat_id, 'admin_wait_cfg_link', ['order_id' => $order_id, 'src_mid' => $mid, 'src_text' => (string)$messageText]);
        sendMessage($chat_id, "لینک ساب را برای سفارش #{$order_id} ارسال کنید:", adminMenuKeyboard());
        return;
    }

    // رد کردن سفارش (فیش فیک) و دریافت علت از ادمین
    if (strpos($data, 'admin:order:reject:') === 0) {
        $order_id = (int)substr($data, strlen('admin:order:reject:'));
        clearState($chat_id);
        setState($chat_id, 'admin_reject_reason', ['kind' => 'order', 'id' => $order_id, 'src_mid' => $mid, 'src_text' => (string)$messageText]);
        sendMessage($chat_id, "⛔️ رد سفارش #{$order_id}\n\n✍️ لطفاً علت رد شدن (فیش فیک/نامعتبر) را بنویسید.\nاین متن برای کاربر ارسال می‌شود.", adminMenuKeyboard());
        return;
    }



    // =========================
    // تایید/رد شارژ کیف پول (درخواست کاربر)
    // =========================
    if (strpos($data, 'admin:wallet:topup:approve:') === 0) {
        $tid = (int)substr($data, strlen('admin:wallet:topup:approve:'));
        $pdo = db();
        $q = $pdo->prepare("SELECT t.*, u.chat_id AS u_chat_id, u.username, u.first_name, u.last_name FROM wallet_topups t LEFT JOIN users u ON u.id=t.user_id WHERE t.id=? LIMIT 1");
        $q->execute([$tid]);
        $top = $q->fetch();

        if (!$top) {
            sendMessage($chat_id, "❌ درخواست شارژ یافت نشد.", adminMenuKeyboard());
            return;
        }
        if (($top['status'] ?? '') !== 'pending') {
            sendMessage($chat_id, "ℹ️ این درخواست قبلاً بررسی شده است (وضعیت: {$top['status']}).", adminMenuKeyboard());
            return;
        }

        $amount = (int)($top['amount_toman'] ?? 0);
        if ($amount < 1) $amount = 0;

        $cred = walletCredit((int)$top['user_id'], $amount, null, null, ['kind' => 'topup', 'topup_id' => $tid, 'by' => 'admin']);
        if (empty($cred['ok'])) {
            sendMessage($chat_id, "❌ افزایش موجودی ناموفق بود. دوباره تلاش کنید.", adminMenuKeyboard());
            return;
        }

        $now = time();
        $pdo->prepare("UPDATE wallet_topups SET status='approved', approved_at=? WHERE id=?")->execute([$now, $tid]);

        $to = (int)($top['u_chat_id'] ?? 0);
        if ($to > 0) {
            $msg = "✅ شارژ کیف پول شما تایید شد.\n\n";
            $msg .= "مبلغ: <b>" . formatToman($amount) . " تومان</b>\n";
            $msg .= "موجودی جدید: <b>" . formatToman((int)($cred['balance'] ?? 0)) . " تومان</b>";
            sendMessage($to, $msg, userMenuKeyboard());
        }

        sendMessage($chat_id, "✅ درخواست شارژ #{$tid} تایید شد و موجودی کاربر افزایش یافت.", adminMenuKeyboard());
        return;
    }

    // رد شارژ و دریافت علت از ادمین
    if (strpos($data, 'admin:wallet:topup:reject:') === 0) {
        $tid = (int)substr($data, strlen('admin:wallet:topup:reject:'));
        clearState($chat_id);
        setState($chat_id, 'admin_reject_reason', ['kind' => 'topup', 'id' => $tid, 'src_mid' => $mid, 'src_text' => (string)$messageText]);
        sendMessage($chat_id, "⛔️ رد شارژ کیف پول #{$tid}\n\n✍️ لطفاً علت رد شدن را بنویسید.\nاین متن برای کاربر ارسال می‌شود.", adminMenuKeyboard());
        return;
    }

    if (strpos($data, 'admin:renew:approve:') === 0) {
        $rid = (int)substr($data, strlen('admin:renew:approve:'));
        $pdo = db();

        $rQ = $pdo->prepare("SELECT * FROM renewals WHERE id=? LIMIT 1");
        $rQ->execute([$rid]);
        $r = $rQ->fetch();
        if (!$r) {
            sendMessage($chat_id, "❌ درخواست تمدید یافت نشد.", adminMenuKeyboard());
            return;
        }

        if ($r['status'] !== 'pending') {
            sendMessage($chat_id, "ℹ️ این درخواست قبلاً بررسی شده است (وضعیت: {$r['status']}).", adminMenuKeyboard());
            return;
        }

        $cfgQ = $pdo->prepare("SELECT * FROM configs WHERE id=? LIMIT 1");
        $cfgQ->execute([(int)$r['config_id']]);
        $cfg = $cfgQ->fetch();
        if (!$cfg) {
            sendMessage($chat_id, "❌ کانفیگ مربوطه یافت نشد.", adminMenuKeyboard());
            return;
        }

        $uQ = $pdo->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
        $uQ->execute([(int)$r['user_id']]);
        $userRow = $uQ->fetch();
        if (!$userRow) {
            sendMessage($chat_id, "❌ کاربر یافت نشد.", adminMenuKeyboard());
            return;
        }

        $now = time();
        $pdo->prepare("UPDATE renewals SET status='approved', approved_at=? WHERE id=?")->execute([$now, $rid]);

        sendMessage((int)$userRow['chat_id'], "✅ تمدید کانفیگ «" . htmlspecialchars($cfg['name']) . "» تأیید شد.", userMenuKeyboard());
        sendMessage($chat_id, "✅ تمدید #{$rid} تأیید شد.", adminMenuKeyboard());
        return;
    }

    // رد کردن تمدید (فیش فیک) و دریافت علت از ادمین
    if (strpos($data, 'admin:renew:reject:') === 0) {
        $rid = (int)substr($data, strlen('admin:renew:reject:'));
        clearState($chat_id);
        setState($chat_id, 'admin_reject_reason', ['kind' => 'renewal', 'id' => $rid, 'src_mid' => $mid, 'src_text' => (string)$messageText]);
        sendMessage($chat_id, "⛔️ رد تمدید #{$rid}\n\n✍️ لطفاً علت رد شدن (فیش فیک/نامعتبر) را بنویسید.\nاین متن برای کاربر ارسال می‌شود.", adminMenuKeyboard());
        return;
    }

    if (strpos($data, 'admin:ticket:reply:') === 0) {
        $tid = (int)substr($data, strlen('admin:ticket:reply:'));
        setState($chat_id, 'admin_reply_ticket', ['ticket_id' => $tid, 'src_mid' => $mid, 'src_text' => (string)$messageText]);
        sendMessage($chat_id, "پاسخ خود را برای تیکت #{$tid} ارسال کنید:", adminMenuKeyboard());
        return;
    }

    // ================== Referral callbacks ==================
    if ($data === 'ref:gift') {
        $user = getUserByChatId($chat_id);
        if (!$user) {
            // به جای answerCallbackQuery (که ممکن است قبلاً پاسخ داده شده باشد)، پیام مستقیم می‌فرستیم
            sendMessage($chat_id, "❌ کاربر یافت نشد. /start را بزنید.", userMenuKeyboard());
            return;
        }
        $res = claimReferralGift((int)$user['id']);
        if (!empty($res['ok'])) {
            $msg = "🎁 هدیه عضویت شما فعال شد ✅\n\n";
            $msg .= "مبلغ هدیه: <b>" . formatToman((int)$res['gift']) . " تومان</b>\n";
            $msg .= "موجودی جدید: <b>" . formatToman((int)$res['balance']) . " تومان</b>";
            // پیام نتیجه (مطمئن‌تر از toast/callback)
            sendMessage($chat_id, $msg, userMenuKeyboard());
        } else {
            $reason = $res['reason'] ?? 'failed';
            if ($reason === 'no_referrals') {
                $t = "برای دریافت هدیه، حداقل ۱ زیرمجموعه لازم است.";
            } elseif ($reason === 'already_claimed') {
                $t = "شما قبلاً هدیه عضویت را دریافت کرده‌اید.";
            } elseif ($reason === 'disabled') {
                $t = "هدیه عضویت فعلاً غیرفعال است.";
            } else {
                $t = "❌ دریافت هدیه ناموفق بود. دوباره تلاش کنید.";
            }
            // پیام مستقیم (چون ممکن است callback قبلاً پاسخ داده شده باشد)
            sendMessage($chat_id, "🎁 هدیه عضویت\n\n" . $t, userMenuKeyboard());
        }
        return;
    }

    if ($data === 'ref:link:help') {
        sendMessage($chat_id, "⚠️ لینک دعوت فعلاً قابل تولید نیست. لطفاً username ربات را تنظیم کنید.", userMenuKeyboard());
        return;
    }

}

/**
 * محاسبه قیمت پلن دلخواه
 * - بر اساس پلن‌های موجود (interpolation) برای ۳۰ روز
 * - سپس مقیاس‌دهی بر اساس تعداد روز
 *
 * در صورت نیاز می‌توانید این تابع را با فرمول دلخواه خود تغییر دهید.
 */
function calculateCustomPrice(int $gb, int $days): int {
    $plans = listActivePlans();
    if (!$plans) {
        // fallback
        $base = (int)round($gb * 1400);
        $price = (int)round($base * ($days / 30));
        return (int)round($price / 1000) * 1000;
    }

    // مرتب‌سازی بر اساس حجم
    usort($plans, function($a, $b) { return (int)$a['data_gb'] <=> (int)$b['data_gb']; });

    $lower = null;
    $upper = null;
    foreach ($plans as $p) {
        $v = (int)$p['data_gb'];
        if ($v <= $gb) $lower = $p;
        if ($v >= $gb) { $upper = $p; break; }
    }

    if (!$lower) $lower = $plans[0];
    if (!$upper) $upper = $plans[count($plans)-1];

    $v1 = (int)$lower['data_gb'];
    $p1 = (int)$lower['price_toman'];
    $v2 = (int)$upper['data_gb'];
    $p2 = (int)$upper['price_toman'];

    if ($v1 === $v2) {
        $base30 = $p1;
    } else {
        // interpolation
        $ratio = ($gb - $v1) / ($v2 - $v1);
        $base30 = (int)round($p1 + ($p2 - $p1) * $ratio);
    }

    // اگر حجم بالاتر از بزرگترین پلن است، بر اساس قیمت/گیگ آخرین پلن extrapolate
    $maxV = (int)$plans[count($plans)-1]['data_gb'];
    $maxP = (int)$plans[count($plans)-1]['price_toman'];
    if ($gb > $maxV && $maxV > 0) {
        $perGb = $maxP / $maxV;
        $base30 = (int)round($gb * $perGb);
    }

    // مقیاس‌دهی بر اساس روز
    $price = (int)round($base30 * ($days / 30));

    // رند به نزدیک‌ترین 1000 تومان
    $price = (int)round($price / 1000) * 1000;

    return max(0, $price);
}
