<?php
// اتصال PDO به MySQL
$config = require __DIR__ . '/config.php';

/**
 * اتصال PDO به MySQL با تحمل خطا روی هاست اشتراکی
 * - جلوگیری از باز شدن کانکشن‌های زیاد
 * - retry/backoff برای 1040
 * - ping دوره‌ای و reconnect برای 2006 (Server has gone away)
 */
function db() {
    if (!array_key_exists('__pdo', $GLOBALS)) $GLOBALS['__pdo'] = null;
    if (!array_key_exists('__pdo_last_ping', $GLOBALS)) $GLOBALS['__pdo_last_ping'] = 0;

    $pdo = $GLOBALS['__pdo'];
    $now = time();

    // هر 30 ثانیه یک ping سبک؛ اگر کانکشن قطع شده بود reconnect
    if ($pdo instanceof PDO && ($now - (int)$GLOBALS['__pdo_last_ping']) > 30) {
        try {
            $pdo->query('SELECT 1');
            $GLOBALS['__pdo_last_ping'] = $now;
        } catch (PDOException $e) {
            $msg = $e->getMessage();
            if (strpos($msg, 'Server has gone away') !== false || strpos($msg, '2006') !== false) {
                $GLOBALS['__pdo'] = null;
                $pdo = null;
            } else {
                // سایر خطاها را رد می‌کنیم تا در اولین query مشخص شود
                $GLOBALS['__pdo_last_ping'] = $now;
            }
        }
    }

    if (!($pdo instanceof PDO)) {
        $c = require __DIR__ . '/config.php';
        $dsn = "mysql:host={$c['DB']['HOST']};dbname={$c['DB']['NAME']};charset={$c['DB']['CHARSET']}";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            // روی بعضی هاست‌ها کمک می‌کند تعداد reconnectهای سریع کمتر شود
            PDO::ATTR_PERSISTENT => true,
        ];

        $attempts = 0;
        while (true) {
            $attempts++;
            try {
                $pdo = new PDO($dsn, $c['DB']['USER'], $c['DB']['PASS'], $options);
                $pdo->exec("SET time_zone = '+03:30'");
                $GLOBALS['__pdo'] = $pdo;
                $GLOBALS['__pdo_last_ping'] = $now;
                break;
            } catch (PDOException $e) {
                $msg = $e->getMessage();
                $isTooMany = (strpos($msg, 'Too many connections') !== false) || (strpos($msg, 'SQLSTATE[08004]') !== false) || (strpos($msg, '1040') !== false);
                if ($isTooMany && $attempts < 5) {
                    // backoff: 200ms, 400ms, 800ms, 1600ms
                    usleep(200000 * (2 ** ($attempts - 1)));
                    continue;
                }
                throw $e;
            }
        }
    }

    return $pdo;
}

function db_reset(): void {
    $GLOBALS['__pdo'] = null;
}